/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.IndexColorModel;

class LutWindow
extends ImageWindow
implements ActionListener {
    private Button button;
    private ImageProcessor ip;

    LutWindow(ImagePlus imagePlus, ImageCanvas imageCanvas, ImageProcessor imageProcessor) {
        super(imagePlus, imageCanvas);
        this.ip = imageProcessor;
        this.addPanel();
    }

    void addPanel() {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.button = new Button(" List... ");
        this.button.addActionListener(this);
        panel.add(this.button);
        this.add(panel);
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.button) {
            this.list(this.ip);
        }
    }

    void list(ImageProcessor imageProcessor) {
        IndexColorModel indexColorModel = (IndexColorModel)imageProcessor.getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        StringBuffer stringBuffer = new StringBuffer();
        String string = "Index\tRed\tGreen\tBlue";
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(i + "\t" + (byArray[i] & 0xFF) + "\t" + (byArray2[i] & 0xFF) + "\t" + (byArray3[i] & 0xFF) + "\n");
        }
        TextWindow textWindow = new TextWindow("LUT", string, stringBuffer.toString(), 250, 400);
    }
}

