/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.gui.GUI;
import ij.plugin.ControlPanel;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class TreePanel
implements ActionListener,
WindowListener,
TreeExpansionListener,
TreeWillExpandListener {
    ControlPanel pcp;
    boolean isMainPanel;
    String title;
    boolean isDragging = false;
    Point defaultLocation;
    private JTree pTree;
    private JMenuBar pMenuBar;
    private DefaultMutableTreeNode root;
    private DefaultMutableTreeNode draggingNode = null;
    private DefaultTreeModel pTreeModel;
    private ActionListener listener;
    private JFrame pFrame;
    private JCheckBoxMenuItem pMenu_saveOnClose;
    private JCheckBoxMenuItem pMenu_noClutter;
    private TreePath rootPath;
    private static final int[] _uparrow1_data = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 1, 1, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 14, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 14, 4, 5, 6, 1, 7, 0, 0, 0, 0, 0, 0, 0, 0, 1, 8, 4, 9, 14, 2, 6, 1, 0, 0, 0, 0, 0, 0, 0, 2, 8, 4, 9, 14, 14, 14, 2, 6, 1, 0, 0, 0, 0, 0, 8, 8, 4, 9, 14, 14, 14, 14, 14, 2, 6, 2, 0, 0, 0, 8, 10, 14, 8, 10, 11, 11, 12, 12, 12, 12, 12, 6, 2, 0, 14, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] _uparrow1_ctable = new int[]{33, -16777216, -13619152, -5592406, -1, -12829636, -14342875, -4802890, -10987432, -3947581, -14540254, -13948117, -13750738, -6250336, -8355712};
    private static IndexColorModel iconCM = new IndexColorModel(8, _uparrow1_ctable.length, _uparrow1_ctable, 0, true, 255, 0);
    private static final ImageIcon upIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, (ColorModel)iconCM, _uparrow1_data, 0, 16)));

    public TreePanel(DefaultMutableTreeNode defaultMutableTreeNode, ControlPanel controlPanel, boolean bl) {
        new TreePanel(defaultMutableTreeNode, controlPanel, bl, null);
    }

    public TreePanel(DefaultMutableTreeNode defaultMutableTreeNode, ControlPanel controlPanel, boolean bl, Point point) {
        this.root = defaultMutableTreeNode;
        this.pcp = controlPanel;
        this.isMainPanel = bl;
        this.defaultLocation = point;
        this.rootPath = new TreePath(defaultMutableTreeNode.getPath());
        this.title = (String)defaultMutableTreeNode.getUserObject();
        this.buildTreePanel();
        controlPanel.registerPanel(this);
    }

    public void buildTreePanel() {
        this.pFrame = new JFrame(this.title);
        this.pFrame.setDefaultCloseOperation(2);
        this.pTreeModel = new DefaultTreeModel(this.root);
        this.pTree = new JTree(this.pTreeModel);
        this.pTree.setEditable(false);
        this.pTree.putClientProperty("JTree.lineStyle", "Angled");
        this.pTree.getSelectionModel().setSelectionMode(1);
        this.pTree.setRootVisible(false);
        this.pTree.setShowsRootHandles(true);
        JScrollPane jScrollPane = new JScrollPane(this.pTree);
        this.addMenu();
        this.pFrame.getContentPane().add((Component)jScrollPane, "Center");
        this.addListeners();
        this.pFrame.pack();
        if (this.defaultLocation != null) {
            if (IJ.debugMode) {
                IJ.log("CP.buildTreePanel: " + this.defaultLocation);
            }
            this.pFrame.setLocation(this.defaultLocation.x, this.defaultLocation.y);
        } else {
            this.pcp.restoreGeometry(this);
        }
        if (this.pFrame.getLocation().x == 0) {
            GUI.center(this.pFrame);
        }
        this.setVisible();
        ImageJ imageJ = IJ.getInstance();
        imageJ.addWindowListener(this);
        this.pFrame.addKeyListener(imageJ);
        this.pTree.addKeyListener(imageJ);
    }

    void addMenu() {
        this.pMenuBar = new JMenuBar();
        Insets insets = new Insets(0, 0, 0, 10);
        this.pMenuBar.setMargin(insets);
        if (this.isMainPanel) {
            JMenuItem jMenuItem = new JMenuItem("Help");
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("Help");
            this.pMenuBar.add(jMenuItem);
        } else {
            JMenuItem jMenuItem = new JMenuItem("Show Parent", upIcon);
            jMenuItem.addActionListener(this);
            jMenuItem.setActionCommand("Show Parent");
            this.pMenuBar.add(jMenuItem);
        }
        this.pFrame.setJMenuBar(this.pMenuBar);
    }

    void addListeners() {
        this.addActionListener(this);
        this.pFrame.addWindowListener(this);
        this.pFrame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent componentEvent) {
                Rectangle rectangle = componentEvent.getComponent().getBounds();
                if (IJ.debugMode) {
                    IJ.log("CP.componentMoved: " + rectangle);
                }
                if (rectangle.x > 0) {
                    TreePanel.this.defaultLocation = new Point(rectangle.x, rectangle.y);
                    TreePanel.this.recordGeometry();
                }
            }
        });
        this.pTree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePanel.this.isDragging = false;
                if (TreePanel.this.pcp.requiresDoubleClick() && mouseEvent.getClickCount() != 2) {
                    return;
                }
                int n = TreePanel.this.pTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    TreePanel.this.toAction();
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (TreePanel.this.isDragging) {
                    Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                    SwingUtilities.convertPointToScreen(point, TreePanel.this.pTree);
                    TreePanel.this.tearOff(null, point);
                }
                TreePanel.this.isDragging = false;
            }
        });
        this.pTree.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = TreePanel.this.pTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (((DefaultMutableTreeNode)TreePanel.this.pTree.getLastSelectedPathComponent()).isLeaf()) {
                        return;
                    }
                    TreePanel.this.pFrame.setCursor(new Cursor(13));
                    TreePanel.this.isDragging = true;
                }
            }
        });
        this.pTree.addTreeExpansionListener(this);
        this.pTree.addTreeWillExpandListener(this);
    }

    public String getTitle() {
        return this.title;
    }

    public TreePath getRootPath() {
        return this.rootPath;
    }

    public boolean isTheMainPanel() {
        return this.isMainPanel;
    }

    public JFrame getFrame() {
        return this.pFrame;
    }

    public JTree getTree() {
        return this.pTree;
    }

    public DefaultMutableTreeNode getRootNode() {
        return this.root;
    }

    public Point getDefaultLocation() {
        return this.defaultLocation;
    }

    boolean isVisible() {
        return this.pFrame.isVisible();
    }

    void setBounds(int n, int n2, int n3, int n4) {
        this.pFrame.setBounds(new Rectangle(n, n2, n3, n4));
        this.defaultLocation = new Point(n, n2);
    }

    void setAutoSaveProps(boolean bl) {
        if (this.isTheMainPanel()) {
            this.pMenu_saveOnClose.setSelected(bl);
        }
    }

    boolean getAutoSaveProps() {
        return this.pMenu_saveOnClose.isSelected();
    }

    void restoreExpandedNodes() {
        if (this.pTree == null || this.root == null) {
            return;
        }
        this.pTree.removeTreeExpansionListener(this);
        TreeNode[] treeNodeArray = this.root.getPath();
        Enumeration<TreeNode> enumeration = this.root.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode == this.root) continue;
            Object[] objectArray = defaultMutableTreeNode.getPath();
            TreePath treePath = new TreePath(objectArray);
            String string = treePath.toString();
            Object[] objectArray2 = new DefaultMutableTreeNode[objectArray.length - treeNodeArray.length + 1];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = (DefaultMutableTreeNode)objectArray[i + treeNodeArray.length - 1];
            }
            TreePath treePath2 = new TreePath(objectArray2);
            if (this.pcp.hasExpandedStateProperty(string) && !this.pcp.hasPanelShowingProperty(string)) {
                if (treePath2 == null) continue;
                try {
                    this.pTree.expandPath(treePath2);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (!this.pcp.hasExpandedStateProperty(string) && !this.pTree.isExpanded(treePath2) || !this.pcp.hasPanelShowingProperty(string)) continue;
            this.pTree.collapsePath(treePath2);
            this.pcp.unsetExpandedStateProperty(string);
        }
        this.pTree.addTreeExpansionListener(this);
    }

    public void processEvent(ActionEvent actionEvent) {
        if (this.listener != null) {
            this.listener.actionPerformed(actionEvent);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.add(this.listener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listener = AWTEventMulticaster.remove(this.listener, actionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("Help")) {
            this.showHelp();
            return;
        }
        if (string.equals("Show Parent")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getParent();
            if (defaultMutableTreeNode != null) {
                TreePanel treePanel = this.pcp.getPanelForNode(defaultMutableTreeNode);
                if (treePanel == null) {
                    treePanel = this.pcp.newPanel(defaultMutableTreeNode);
                }
                if (treePanel != null) {
                    treePanel.setVisible();
                }
            }
            return;
        }
        if (!string.equals("Reload Plugins From Panel")) {
            if (string.equals("Reload Plugins")) {
                this.pcp.closeAll(false);
            } else {
                IJ.doCommand(string);
            }
            return;
        }
        this.pcp.closeAll(false);
        IJ.doCommand("Reload Plugins");
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (IJ.debugMode) {
            IJ.log("CP.windowClosing: " + this.isMainPanel);
        }
        if (this.isMainPanel) {
            this.pcp.saveProperties();
        }
        this.pcp.unsetPanelShowingProperty(this.getRootPath().toString());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        String string = treeExpansionEvent.getPath().toString();
        string = string.substring(string.indexOf("[") + 1, string.lastIndexOf("]"));
        string = string.substring(this.getTitle().length() + 2, string.length());
        String string2 = this.getRootPath().toString();
        string2 = string2.substring(string2.indexOf("[") + 1, string2.lastIndexOf("]"));
        String string3 = "[" + string2 + ", " + string + "]";
        this.pcp.unsetExpandedStateProperty(string3);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Hashtable hashtable;
        TreePanel treePanel;
        TreePath treePath = treeExpansionEvent.getPath();
        String string = treeExpansionEvent.getPath().toString();
        string = this.pcp.pStr2Key(string);
        string = string.substring(this.getTitle().length() + 1, string.length());
        String string2 = this.getRootPath().toString();
        String string3 = (string2 = this.pcp.pStr2Key(string2)) + "." + string;
        if (this.pcp.hasPanelShowingProperty(string3) && (treePanel = (TreePanel)(hashtable = this.pcp.getPanels()).get(string3)) != null) {
            treePanel.close();
        }
        this.pcp.setExpandedStateProperty(string3);
    }

    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
    }

    void recordGeometry() {
        this.pcp.recordGeometry(this);
    }

    void refreshTree() {
        this.pTreeModel.reload();
    }

    void tearOff() {
        this.tearOff(null);
    }

    void tearOff(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.tearOff(defaultMutableTreeNode, null);
    }

    void tearOff(DefaultMutableTreeNode defaultMutableTreeNode, Point point) {
        this.isDragging = false;
        this.pFrame.setCursor(Cursor.getDefaultCursor());
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.pTree.getLastSelectedPathComponent();
        }
        if (defaultMutableTreeNode.isLeaf()) {
            return;
        }
        Object[] objectArray = defaultMutableTreeNode.getPath();
        TreeNode[] treeNodeArray = this.root.getPath();
        Object[] objectArray2 = new DefaultMutableTreeNode[objectArray.length - treeNodeArray.length + 1];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = (DefaultMutableTreeNode)objectArray[i + treeNodeArray.length - 1];
        }
        TreePath treePath = new TreePath(objectArray);
        TreePath treePath2 = new TreePath(objectArray2);
        String string = treePath2.toString();
        TreePanel treePanel = this.pcp.getPanelForNode(defaultMutableTreeNode);
        if (treePanel == null) {
            treePanel = point != null ? this.pcp.newPanel(defaultMutableTreeNode, point) : this.pcp.newPanel(defaultMutableTreeNode);
            this.pTree.collapsePath(treePath2);
        } else {
            if (point != null) {
                treePanel.setLocation(point);
            }
            treePanel.setVisible();
            this.pTree.collapsePath(treePath2);
        }
    }

    void toAction() {
        String string;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.pTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode.getChildCount() > 0) {
            return;
        }
        String string2 = string = defaultMutableTreeNode.toString();
        if (this.pcp.treeCommands.containsKey(string)) {
            string2 = (String)this.pcp.treeCommands.get(string);
        }
        this.processEvent(new ActionEvent(this, 1001, string2));
    }

    void setVisible() {
        if (this.pFrame != null && !this.pFrame.isVisible()) {
            TreePanel treePanel;
            this.restoreExpandedNodes();
            if (this.defaultLocation != null) {
                this.pFrame.setLocation(this.defaultLocation);
            }
            this.pFrame.setVisible(true);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.root.getParent();
            if (defaultMutableTreeNode != null && (treePanel = this.pcp.getPanelForNode(defaultMutableTreeNode)) != null && treePanel.isVisible()) {
                TreeNode[] treeNodeArray = this.root.getPath();
                TreeNode[] treeNodeArray2 = treePanel.getRootNode().getPath();
                Object[] objectArray = new DefaultMutableTreeNode[treeNodeArray.length - treeNodeArray2.length + 1];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = (DefaultMutableTreeNode)treeNodeArray[i + treeNodeArray2.length - 1];
                }
                TreePath treePath = new TreePath(objectArray);
                treePanel.getTree().collapsePath(treePath);
            }
        }
        if (this.pcp != null) {
            this.pcp.setPanelShowingProperty(this.getRootPath().toString());
        }
    }

    void setLocation(Point point) {
        if (point != null) {
            this.defaultLocation = point;
        }
    }

    void close() {
        this.pFrame.dispatchEvent(new WindowEvent(this.pFrame, 201));
        this.pcp.unsetPanelShowingProperty(this.getRootPath().toString());
    }

    private void showHelp() {
        this.pcp.showHelp();
    }
}

