/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.OpenDialog;
import ij.io.TiffDecoder;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.IOException;
import java.util.Properties;

public class FileInfoVirtualStack
extends VirtualStack
implements PlugIn {
    FileInfo[] info;
    int nImages;

    public FileInfoVirtualStack() {
    }

    public FileInfoVirtualStack(FileInfo fileInfo) {
        this.info = new FileInfo[1];
        this.info[0] = fileInfo;
        this.open();
    }

    public void run(String string) {
        OpenDialog openDialog = new OpenDialog("Open TIFF", string);
        String string2 = openDialog.getFileName();
        if (string2 == null) {
            return;
        }
        if (string2.endsWith(".zip")) {
            IJ.error("Virtual Stack", "ZIP compressed stacks not supported");
            return;
        }
        String string3 = openDialog.getDirectory();
        TiffDecoder tiffDecoder = new TiffDecoder(string3, string2);
        if (IJ.debugMode) {
            tiffDecoder.enableDebugging();
        }
        IJ.showStatus("Decoding TIFF header...");
        try {
            this.info = tiffDecoder.getTiffInfo();
        }
        catch (IOException iOException) {
            String string4 = iOException.getMessage();
            if (string4 == null || string4.equals("")) {
                string4 = "" + iOException;
            }
            IJ.error("TiffDecoder", string4);
            return;
        }
        if (this.info == null || this.info.length == 0) {
            IJ.error("Virtual Stack", "This does not appear to be a TIFF stack");
            return;
        }
        if (IJ.debugMode) {
            IJ.log(this.info[0].debugInfo);
        }
        this.open();
    }

    void open() {
        FileInfo fileInfo = this.info[0];
        int n = fileInfo.nImages;
        if (this.info.length == 1 && n > 1) {
            this.info = new FileInfo[n];
            long l = fileInfo.width * fileInfo.height * fileInfo.getBytesPerPixel();
            for (int i = 0; i < n; ++i) {
                this.info[i] = (FileInfo)fileInfo.clone();
                this.info[i].nImages = 1;
                this.info[i].longOffset = fileInfo.getOffset() + (long)i * (l + (long)fileInfo.gapBetweenImages);
            }
        }
        this.nImages = this.info.length;
        FileOpener fileOpener = new FileOpener(this.info[0]);
        ImagePlus imagePlus = fileOpener.open(false);
        Properties properties = fileOpener.decodeDescriptionString(fileInfo);
        ImagePlus imagePlus2 = new ImagePlus(fileInfo.fileName, this);
        imagePlus2.setFileInfo(fileInfo);
        if (imagePlus != null && properties != null) {
            int n2;
            int n3;
            int n4;
            imagePlus2.setCalibration(imagePlus.getCalibration());
            if (fileInfo.info != null) {
                imagePlus2.setProperty("Info", fileInfo.info);
            }
            if ((n4 = this.getInt(properties, "channels")) * (n3 = this.getInt(properties, "slices")) * (n2 = this.getInt(properties, "frames")) == this.nImages) {
                imagePlus2.setDimensions(n4, n3, n2);
                if (this.getBoolean(properties, "hyperstack")) {
                    imagePlus2.setOpenAsHyperStack(true);
                }
            }
            if (n4 > 1 && fileInfo.description != null) {
                int n5 = 1;
                if (fileInfo.description.indexOf("mode=color") != -1) {
                    n5 = 2;
                } else if (fileInfo.description.indexOf("mode=gray") != -1) {
                    n5 = 3;
                }
                imagePlus2 = new CompositeImage(imagePlus2, n5);
            }
        }
        imagePlus2.show();
    }

    int getInt(Properties properties, String string) {
        Double d = this.getNumber(properties, string);
        return d != null ? (int)d.doubleValue() : 1;
    }

    Double getNumber(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                return Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    boolean getBoolean(Properties properties, String string) {
        String string2 = properties.getProperty(string);
        return string2 != null && string2.equals("true");
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nImages < 1) {
            return;
        }
        for (int i = n; i < this.nImages; ++i) {
            this.info[i - 1] = this.info[i];
        }
        this.info[this.nImages - 1] = null;
        --this.nImages;
    }

    public ImageProcessor getProcessor(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (IJ.debugMode) {
            IJ.log("FileInfoVirtualStack: " + n + ", " + this.info[n - 1].getOffset());
        }
        this.info[n - 1].nImages = 1;
        FileOpener fileOpener = new FileOpener(this.info[n - 1]);
        ImagePlus imagePlus = fileOpener.open(false);
        if (imagePlus != null) {
            return imagePlus.getProcessor();
        }
        return null;
    }

    public int getSize() {
        return this.nImages;
    }

    public String getSliceLabel(int n) {
        if (n < 1 || n > this.nImages) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.info[0].sliceLabels == null || this.info[0].sliceLabels.length != this.nImages) {
            return null;
        }
        return this.info[0].sliceLabels[n - 1];
    }

    public int getWidth() {
        return this.info[0].width;
    }

    public int getHeight() {
        return this.info[0].height;
    }
}

