/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import com.sun.tools.javac.Main;
import ij.IJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.plugin.PlugInExecuter;
import ij.plugin.frame.Editor;
import java.awt.Font;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Vector;

public class Compiler
implements PlugIn,
FilenameFilter {
    private static final int TARGET14 = 0;
    private static final int TARGET15 = 1;
    private static final int TARGET16 = 2;
    private static final int TARGET17 = 3;
    private static final String[] targets = new String[]{"1.4", "1.5", "1.6", "1.7"};
    private static final String TARGET_KEY = "javac.target";
    private static Main javac;
    private static ByteArrayOutputStream output;
    private static String dir;
    private static String name;
    private static Editor errors;
    private static boolean generateDebuggingInfo;
    private static int target;

    public void run(String string) {
        if (string.equals("edit")) {
            this.edit();
        } else if (string.equals("options")) {
            this.showDialog();
        } else {
            this.compileAndRun(string);
        }
    }

    void edit() {
        Editor editor;
        if (this.open("", "Open macro or plugin") && (editor = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "")) != null) {
            editor.open(dir, name);
        }
    }

    void compileAndRun(String string) {
        if (!this.open(string, "Compile and Run Plugin...")) {
            return;
        }
        if (name.endsWith(".class")) {
            this.runPlugin(name.substring(0, name.length() - 1));
            return;
        }
        if (!this.isJavac()) {
            return;
        }
        if (this.compile(dir + name)) {
            this.runPlugin(name);
        }
    }

    boolean isJavac() {
        try {
            if (javac == null) {
                output = new ByteArrayOutputStream(4096);
                javac = new Main();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            IJ.error("Unable to find the javac compiler, which comes with the Windows and \nLinux versions of ImageJ that include Java in the ImageJ/jre folder.\n \n   java.home: " + System.getProperty("java.home"));
            return false;
        }
        return true;
    }

    boolean compile(String string) {
        boolean bl;
        IJ.showStatus("compiling: " + string);
        output.reset();
        String string2 = this.getClassPath(string);
        Vector<String> vector = new Vector<String>();
        if (generateDebuggingInfo) {
            vector.addElement("-g");
        }
        if (IJ.isJava15()) {
            this.validateTarget();
            vector.addElement("-source");
            vector.addElement(targets[target]);
            vector.addElement("-target");
            vector.addElement(targets[target]);
            vector.addElement("-Xlint:unchecked");
        }
        vector.addElement("-deprecation");
        vector.addElement("-classpath");
        vector.addElement(string2);
        vector.addElement(string);
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        if (IJ.debugMode) {
            String string3 = "javac";
            for (int i = 0; i < objectArray.length; ++i) {
                string3 = string3 + " " + (String)objectArray[i];
            }
            IJ.log(string3);
        }
        boolean bl2 = Main.compile((String[])objectArray, new PrintWriter(output)) == 0;
        String string4 = output.toString();
        boolean bl3 = bl = !bl2 || this.areErrors(string4);
        if (bl) {
            this.showErrors(string4);
        } else {
            IJ.showStatus("done");
        }
        return bl2;
    }

    String getClassPath(String string) {
        String string2;
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(System.getProperty("java.class.path"));
        File file = new File(string);
        if (file != null) {
            stringBuffer.append(File.pathSeparator + file.getParent());
        }
        if ((string2 = Menus.getPlugInsPath()) != null) {
            this.addJars(string2, stringBuffer);
        }
        return stringBuffer.toString();
    }

    void addJars(String string, StringBuffer stringBuffer) {
        String[] stringArray = null;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            stringArray = file.list();
        }
        if (stringArray == null) {
            return;
        }
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(string + stringArray[i]);
            if (file2.isDirectory()) {
                this.addJars(string + stringArray[i], stringBuffer);
                continue;
            }
            if (!stringArray[i].endsWith(".jar") || stringArray[i].indexOf("_") != -1 && !stringArray[i].equals("loci_tools.jar")) continue;
            stringBuffer.append(File.pathSeparator + string + stringArray[i]);
            if (!IJ.debugMode) continue;
            IJ.log("javac: " + string + stringArray[i]);
        }
    }

    public static boolean compileFile(String string) {
        Compiler compiler = new Compiler();
        if (!compiler.isJavac()) {
            return false;
        }
        return compiler.compile(string);
    }

    boolean areErrors(String string) {
        boolean bl;
        boolean bl2 = bl = string != null && string.length() > 0;
        if (bl && string.indexOf("1 warning") > 0 && string.indexOf("[deprecation] show()") > 0) {
            bl = false;
        }
        return bl;
    }

    void showErrors(String string) {
        if (errors == null || !errors.isVisible()) {
            errors = (Editor)IJ.runPlugIn("ij.plugin.frame.Editor", "");
            errors.setFont(new Font("Monospaced", 0, 12));
        }
        if (errors != null) {
            errors.display("Errors", string);
        }
        IJ.showStatus("done (errors)");
    }

    boolean open(String string, String string2) {
        boolean bl;
        String string3;
        String string4;
        if (string.equals("")) {
            String string5;
            if (dir == null) {
                dir = IJ.getDirectory("plugins");
            }
            OpenDialog openDialog = new OpenDialog(string2, dir, name);
            string4 = openDialog.getDirectory();
            string3 = openDialog.getFileName();
            bl = string3 != null;
            String string6 = string5 = bl ? string3.toLowerCase(Locale.US) : null;
            if (bl) {
                if (string2.startsWith("Compile")) {
                    if (!string5.endsWith(".java") && !string5.endsWith(".class")) {
                        IJ.error("File name must end with \".java\" or \".class\".");
                        bl = false;
                    }
                } else if (!(string5.endsWith(".java") || string5.endsWith(".txt") || string5.endsWith(".ijm") || string5.endsWith(".js"))) {
                    IJ.error("File name must end with \".java\", \".txt\" or \".js\".");
                    bl = false;
                }
            }
        } else {
            int n = string.lastIndexOf(47);
            if (n == -1) {
                n = string.lastIndexOf(92);
            }
            if (n > 0) {
                string4 = string.substring(0, n + 1);
                string3 = string.substring(n + 1);
            } else {
                string4 = "";
                string3 = string;
            }
            bl = true;
        }
        if (bl) {
            name = string3;
            dir = string4;
            Editor.setDefaultDirectory(dir);
        }
        return bl;
    }

    public boolean accept(File file, String string) {
        return string.endsWith(".java") || string.endsWith(".macro") || string.endsWith(".txt");
    }

    void runPlugin(String string) {
        string = string.substring(0, string.length() - 5);
        new PlugInExecuter(string);
    }

    public void showDialog() {
        this.validateTarget();
        GenericDialog genericDialog = new GenericDialog("Compile and Run");
        genericDialog.addChoice("Target: ", targets, targets[target]);
        genericDialog.setInsets(15, 5, 0);
        genericDialog.addCheckbox("Generate debugging info (javac -g)", generateDebuggingInfo);
        genericDialog.addHelp("http://imagej.nih.gov/ij/docs/menus/edit.html#compiler");
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        target = genericDialog.getNextChoiceIndex();
        generateDebuggingInfo = genericDialog.getNextBoolean();
        this.validateTarget();
    }

    void validateTarget() {
        if (target < 0 || target > 3) {
            target = 1;
        }
        if (target > 2 && !IJ.isJava17() || target > 1 && !IJ.isJava16()) {
            target = 1;
        }
        if (!IJ.isJava15()) {
            target = 0;
        }
        Prefs.set(TARGET_KEY, target);
    }

    static {
        target = (int)Prefs.get(TARGET_KEY, 1.0);
    }
}

