/*
 * Decompiled with CFR 0.152.
 */
package ij;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.io.File;

public class VirtualStack
extends ImageStack {
    private static final int INITIAL_SIZE = 100;
    private String path;
    private int nSlices;
    private String[] names;
    private String[] labels;
    private int bitDepth;

    public VirtualStack() {
    }

    public VirtualStack(int n, int n2, ColorModel colorModel, String string) {
        super(n, n2, colorModel);
        this.path = string;
        this.names = new String[100];
        this.labels = new String[100];
    }

    public void addSlice(String string) {
        if (string == null) {
            throw new IllegalArgumentException("'name' is null!");
        }
        ++this.nSlices;
        if (this.nSlices == this.names.length) {
            String[] stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.names, 0, stringArray, 0, this.nSlices);
            this.names = stringArray;
            stringArray = new String[this.nSlices * 2];
            System.arraycopy(this.labels, 0, stringArray, 0, this.nSlices);
            this.labels = stringArray;
        }
        this.names[this.nSlices - 1] = string;
    }

    public void addSlice(String string, Object object) {
    }

    public void addSlice(String string, ImageProcessor imageProcessor) {
    }

    public void addSlice(String string, ImageProcessor imageProcessor, int n) {
    }

    public void deleteSlice(int n) {
        if (n < 1 || n > this.nSlices) {
            throw new IllegalArgumentException("Argument out of range: " + n);
        }
        if (this.nSlices < 1) {
            return;
        }
        for (int i = n; i < this.nSlices; ++i) {
            this.names[i - 1] = this.names[i];
        }
        this.names[this.nSlices - 1] = null;
        --this.nSlices;
    }

    public void deleteLastSlice() {
        if (this.nSlices > 0) {
            this.deleteSlice(this.nSlices);
        }
    }

    public Object getPixels(int n) {
        ImageProcessor imageProcessor = this.getProcessor(n);
        if (imageProcessor != null) {
            return imageProcessor.getPixels();
        }
        return null;
    }

    public void setPixels(Object object, int n) {
    }

    public ImageProcessor getProcessor(int n) {
        ImagePlus imagePlus = new Opener().openImage(this.path, this.names[n - 1]);
        if (imagePlus == null) {
            File file = new File(this.path, this.names[n - 1]);
            String string = file.exists() ? "error opening " : "file not found: ";
            throw new RuntimeException(string + this.path + this.names[n - 1]);
        }
        int n2 = imagePlus.getWidth();
        int n3 = imagePlus.getHeight();
        int n4 = imagePlus.getType();
        ColorModel colorModel = imagePlus.getProcessor().getColorModel();
        this.labels[n - 1] = (String)imagePlus.getProperty("Info");
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        if (imagePlus.getBitDepth() != this.bitDepth) {
            switch (this.bitDepth) {
                case 8: {
                    imageProcessor = imageProcessor.convertToByte(true);
                    break;
                }
                case 16: {
                    imageProcessor = imageProcessor.convertToShort(true);
                    break;
                }
                case 24: {
                    imageProcessor = imageProcessor.convertToRGB();
                    break;
                }
                case 32: {
                    imageProcessor = imageProcessor.convertToFloat();
                }
            }
        }
        if (imageProcessor.getWidth() != this.getWidth() || imageProcessor.getHeight() != this.getHeight()) {
            imageProcessor = imageProcessor.resize(this.getWidth(), this.getHeight());
        }
        return imageProcessor;
    }

    public int saveChanges(int n) {
        return -1;
    }

    public int getSize() {
        return this.nSlices;
    }

    public String getSliceLabel(int n) {
        String string = this.labels[n - 1];
        if (string == null) {
            return this.names[n - 1];
        }
        if (string.length() <= 60) {
            return string;
        }
        return this.names[n - 1] + "\n" + string;
    }

    public Object[] getImageArray() {
        return null;
    }

    public void setSliceLabel(String string, int n) {
    }

    public boolean isVirtual() {
        return true;
    }

    public void trim() {
    }

    public String getDirectory() {
        return this.path;
    }

    public String getFileName(int n) {
        return this.names[n - 1];
    }

    public void setBitDepth(int n) {
        this.bitDepth = n;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }
}

