% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nifti.R
\encoding{UTF-8}
\name{load_nifti}
\alias{load_nifti}
\title{Loads NIfTI images to RIA image format}
\usage{
load_nifti(
  filename,
  image_dim = 3,
  mask_filename = NULL,
  keep_mask_values = 1,
  switch_z = TRUE,
  crop_in = TRUE,
  replace_in = TRUE,
  center_in = FALSE,
  zero_value = NULL,
  min_to = -1024,
  verbose_in = TRUE,
  reorient_in = TRUE,
  ...
)
}
\arguments{
\item{filename}{string, file path to directory containing \emph{NIfTI} file.}

\item{image_dim}{integer, dimensions of the image.}

\item{mask_filename}{string vector, file path to optional directory containing \emph{NIfTI} file
of mask image. If multiple are supplied, then those voxels are kept which have one of the values of \emph{keep_mask_values}
in any of the supplied masks.}

\item{keep_mask_values}{integer vector or string, indicates which value or values of the mask image
to use as indicator to identify voxels wished to be processed. Usually 1-s indicate voxels
wished to be processed. However, one mask image might contain several segmentations, in which
case supplying several integers is allowed. Furthermore, if the same string is supplied to
\emph{filename} and \emph{mask_filename}, then the integers in \emph{keep_mask_values} are used
to specify which voxel values to analyze. This way the provided image can be segmented to specific
components. For example, if you wish to analyze only the low-density non-calcified component
of coronary plaques, then \emph{keep_mask_values} can specify this by setting it to: -100:30.
If  a single string is provided, then each element of the mask will be examined against the statement in the string.
For example, if \emph{'>0.5'} is provided i.e. the mask is probabilities after a DL algorithm, then all
voxels with values >0.5 in the mask image will be kept. This can be a complex logical expression.
The data on which the expression is executed is called \emph{data} or \emph{data_mask}, depending on whether
you wish to filter the original image, that is the original image is supplied as a mask, or if you have
unique mask files respectively. Therefore for complex logical expressions you can define for example:
\emph{'>-100 & data<30'} to consider data values between -100 and 30, or \emph{'>0.5 & data_mask<0.75'}
to select voxels based-on mask values between 0.5 and 0.75 for example if they represent a probability mask.}

\item{switch_z}{logical, indicating whether to change the orientation of the images in the Z axis. Some
software reverse the order of the manipulated image in the Z axis, and therefore the images of the mask
image need to be reveresed.}

\item{crop_in}{logical, indicating whether to crop \emph{RIA_image} to smallest bounding box.}

\item{replace_in}{logical, whether to replace smallest values indicated by \emph{zero_value},
which are considered to indicate no signal, to NA.}

\item{center_in}{logical, whether to shift data so smallest value
is equal to \emph{min_to} input parameter.}

\item{zero_value}{integer, indicating voxels values which are considered
not to have any information. If left empty,
then the smallest HU value in the image will be used, if \emph{replace_in} is TRUE.}

\item{min_to}{integer, value to which data is shifted to if \emph{center_in} is TRUE.}

\item{verbose_in}{logical, indicating whether to print detailed information.
Most prints can also be suppresed using the \code{\link{suppressMessages}} function.}

\item{reorient_in}{\emph{reorient} parameter input of \code{\link[oro.nifti]{readNIfTI}}.}

\item{...}{additional arguments to  \code{\link[oro.nifti]{readNIfTI}},
\code{\link[oro.nifti]{nifti_header}}.}
}
\value{
Returns a \emph{RIA_image} object. \emph{RIA_image} is a list with three mandatory attributes.
\itemize{
 \item \bold{RIA_data} is a \emph{RIA_data} object containing the image in \emph{$orig} slot.
 \item \bold{RIA_header} is a \emph{RIA_header} object, which is s list of meta information.
 \item \bold{RIA_log} is a \emph{RIA_log} object, which is a list updated by RIA functions
 and acts as a log and possible input for some functions.
 }
}
\description{
Loads NIfTI images to a \emph{RIA_image} object.
\emph{RIA_image} is a  list with three mandatory attributes.
\itemize{
 \item \bold{RIA_data} is a \emph{RIA_data} object, which has two potential slots.
 \emph{$orig} contains the original image after loading
 \emph{$modif} contains the image that has been modified using functions.
 \item \bold{RIA_header} is a \emph{RIA_header} object, which is list of header information.
 \item \bold{RIA_log} is a \emph{RIA_log} object, which is a list updated by RIA functions
 and acts as a log and possible input for some functions.
 }
 Further attributes may also be added by RIA functions.
}
\details{
\emph{load_nifti} is used to transform NIfTI datasets into the RIA environment.
\emph{RIA_image} object was developed to facilitate and simplify radiomics calculations by keeping
all necessary information in one place.
\cr
\cr
\emph{RIA_data} stores the image that is converted to numerical 3D arrays using
\code{\link[oro.nifti]{readNIfTI}}.
The function stores the original loaded image in  \emph{RIA_data$orig},
while all modified images are stored in \emph{RIA_data$modif}.
By default, the original image \emph{RIA_data$orig} is untouched by functions
other than those operating in \emph{load_nifti}. While other functions
operate on the \emph{RIA_data$modif} image by default.
\cr
Due to memory concerns, there can only be one \emph{RIA_data$orig} and \emph{RIA_data$modif}
image present at one time in a \emph{RIA_image}. Therefore, if image manipulations are performed,
then the \emph{RIA_data$modif} will be overwritten. However, functions can save images
into new slots of \emph{RIA_image}, for example the \code{\link[RIA]{discretize}} function can save
discretized images to the \emph{discretized} slot of \emph{RIA_image}.
\cr
\emph{load_nifti} not only loads the image based on parameters that can be set for
\code{\link[oro.nifti]{readNIfTI}}, but also can perform
minimal manipulations on the image itself.
\cr
\emph{crop_in} logical variable is used to indicate, whether to crop the image to the
smallest bounding box still containing all the information. If TRUE, then all X, Y and potentially
Z slices containing no information will be removed. This allows significant reduction of necessary
memory to store image data.
\cr
\emph{zero_value} parameter is used to indicate HU values which contain no information. If left empty,
then the smallest value will be considered as indicating voxels without a signal.
\cr
\emph{replace_in} logical can be used to change values that are considered to have no signal to NA.
This is necessary to receive proper statistical values later on.
\cr
\emph{center_in} logical is used to indicate whether the values should be shifted.
Some vendors save HU values as positive integers to spare memory and minimalize file sizes.
Therefore, in some instances shift of the scale is needed. By default,
the values are shifted by -1024, but in other cases a different constant might be required,
which can be set using the \emph{min_to} input.
\cr
\cr
\emph{RIA_header} is a list containing the most basic patient and examination information
present in the NIfTI file.
\cr
\cr
\emph{RIA_log} is a list of variables, which give an overview of what has been done with the image.
If the whole \emph{RIA_image} is supplied to a function, the information regarding the manipulations
are written into the \emph{$events} array in chronological order. Furthermore, some additional
information is also saved in the log, which might be needed for further analysis.
}
\examples{
\dontrun{
 #Image will be croped to smallest bounding box, and smallest values will be changed to NA,
 while 1024 will be substracted from all other data points.
 RIA_image <- load_nifti("/Users/Test/Documents/Radiomics/John_Smith/NIfTI_folder/sample.nii")
 }
 
}
\references{
Márton KOLOSSVÁRY et al.
Radiomic Features Are Superior to Conventional Quantitative Computed Tomographic
Metrics to Identify Coronary Plaques With Napkin-Ring Sign
Circulation: Cardiovascular Imaging (2017).
DOI: 10.1161/circimaging.117.006843
\url{https://pubmed.ncbi.nlm.nih.gov/29233836/}

Márton KOLOSSVÁRY et al.
Cardiac Computed Tomography Radiomics: A Comprehensive Review on Radiomic Techniques.
Journal of Thoracic Imaging (2018).
DOI: 10.1097/RTI.0000000000000268
\url{https://pubmed.ncbi.nlm.nih.gov/28346329/}
}
