% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_dicom.R
\name{load_dicom}
\alias{load_dicom}
\title{Loads DICOM images to RIA image format}
\usage{
load_dicom(filename, crop_in = TRUE, replace_in = TRUE, center_in = TRUE,
  zero_value = NULL, min_to = -1024, header_add = NULL,
  header_exclude = NULL, verbose_in = TRUE, recursive_in = TRUE,
  exclude_in = "sql", mode_in = "integer", transpose_in = TRUE,
  pixelData_in = TRUE, mosaic_in = FALSE, mosaicXY_in = NULL,
  sequence_in = FALSE)
}
\arguments{
\item{filename}{string, file path to directory containing \emph{dcm} files.}

\item{crop_in}{logical, indicating whether to crop \emph{RIA_image} to smallest bounding box.}

\item{replace_in}{logical, whether to replace smallest values indicated by \emph{zero_value},
which are considered to indicate no signal, to NA.}

\item{center_in}{logical, whether to shift data so smallest value
is equal to \emph{min_to} input parameter.}

\item{zero_value}{integer, indicating voxels values which are considered
not to have any information. If left empty,
then the smallest HU value in the image will be used, if \emph{replace_in} is TRUE.}

\item{min_to}{integer, value to which data is shifted to if \emph{center_in} is TRUE.}

\item{header_add}{dataframe, with three columns: Name, Group and Element containing the name,
the group and the element code of the DICOM fields wished to be added to the\emph{RIA_header}.}

\item{header_exclude}{dataframe, with three columns: Name, Group and Element containing the name,
the group and the element code of the DICOM fields wished to be excluded
from the default header elements present in \emph{DICOM_codes} rda file.}

\item{verbose_in}{logical, indicating whether to print detailed information.
Most prints can also be suppresed using the \code{\link{suppressMessages}} function.}

\item{recursive_in}{\emph{recursive} parameter input of \code{\link[oro.dicom]{readDICOM}}.}

\item{exclude_in}{\emph{exclude} parameter input of \code{\link[oro.dicom]{readDICOM}}.}

\item{mode_in}{\emph{mode} parameter input of \code{\link[oro.dicom]{create3D}}.}

\item{transpose_in}{\emph{transpose} parameter input of \code{\link[oro.dicom]{create3D}}.}

\item{pixelData_in}{\emph{pixelData} parameter input of \code{\link[oro.dicom]{create3D}}.}

\item{mosaic_in}{\emph{mosaic} parameter input of \code{\link[oro.dicom]{create3D}}.}

\item{mosaicXY_in}{\emph{mosaicXY} parameter input of \code{\link[oro.dicom]{create3D}}.}

\item{sequence_in}{\emph{sequence} parameter input of \code{\link[oro.dicom]{create3D}}.}
}
\value{
Returns a \emph{RIA_image} object. \emph{RIA_image} is a list with three mandatory attributes.
\itemize{
 \item \bold{RIA_data} is a \emph{RIA_data} object containing the image in \emph{$orig} slot.
 \item \bold{RIA_header} is a \emph{RIA_header} object, which is s list of DICOM information.
 \item \bold{RIA_log} is a \emph{RIA_log} object, which is a list updated by RIA functions
 and acts as a log and possible input for some functions.
 }
}
\description{
Loads DICOM images to a \emph{RIA_image} object.
\emph{RIA_image} is a  list with three mandatory attributes.
\itemize{
 \item \bold{RIA_data} is a \emph{RIA_data} object, which has two potential slots.
 \emph{$orig} contains the original image after loading and is a 3D array of integers
 created with \code{\link[oro.dicom]{create3D}}.
 \emph{$modif} contains the image that has been modified using functions.
 \item \bold{RIA_header} is a \emph{RIA_header} object, which is list of DICOM header information.
 \item \bold{RIA_log} is a \emph{RIA_log} object, which is a list updated by RIA functions
 and acts as a log and possible input for some functions.
 }
 Further attributes may also be added by RIA functions.
}
\details{
\emph{load_dicom} is used to transform DICOM datasets into the RIA environment.
\emph{RIA_image} object was developed to facilitate and simplify radiomics calculations by keeping
all necessary information in one place.
\cr
\cr
\emph{RIA_data} stores the DICOM image that is converted to numerical 3D arrays using
\code{\link[oro.dicom]{readDICOM}} and \code{\link[oro.dicom]{create3D}}.
The function stores the original loaded image in  \emph{RIA_data$orig},
while all modified images are stored in \emph{RIA_data$modif}.
By default, the original image \emph{RIA_data$orig} is untouched by functions
other than those operating in \emph{load_dicom}. While other functions
operate on the \emph{RIA_data$modif} image by default.
\cr
Due to memory concerns, there can only be one \emph{RIA_data$orig} and \emph{RIA_data$modif}
image present at one time in a \emph{RIA_image}. Therefore, if image manipulations are performed,
then the \emph{RIA_data$modif} will be overwritten. However, functions can save images
into new slots of \emph{RIA_image}, for example the \code{\link[RIA]{dichotomize}} function can save
dichotomized images to the \emph{dichotomized} slot of \emph{RIA_image}.
\cr
\emph{load_dicom} not only loads the DICOM image based on parameters that can be set for
\code{\link[oro.dicom]{readDICOM}} and \code{\link[oro.dicom]{create3D}}, but also can perform
minimal manipulations on the image itself.
\cr
\emph{crop_in} logical variable is used to indicate, whether to crop the image to the
smallest bounding box still containing all the information. If TRUE, then all X, Y and potentially
Z slices containing no information will be removed. This allows significant reduction of necessary
memory to store image data.
\cr
\emph{zero_value} parameter is used to indicate HU values which contain no information. If left empty,
then the smallest value will be considered as indicating voxels without a signal.
\cr
\emph{replace_in} logical can be used to change values that are considered to have no signal to NA.
This is necessary to receive proper statistical values later on.
\cr
\emph{center_in} logical is used to indicate whether the values should be shifted.
Some vendors save HU values as positive integers to spare memory and minimalize file sizes.
Therefore, in some instances shift of the scale is needed. By default,
the values are shifted by -1024, but in other cases a different constant might be required,
which can be set using the \emph{min_to} input.
\cr
\cr
\emph{RIA_header} is a list containing the most basic patient and examination information
needed for further analysis. The default DICOM set is present in \emph{DICOM_codes},
which can be edited to anyones needs. But if we wish only to add of remove specific
DICOM header rows, then the \emph{header_add} and \emph{header_exclude} can be used.
\cr
\cr
\emph{RIA_log} is a list of variables, which give an overview of what has been done with the image.
If the whole \emph{RIA_image} is supplied to a function, the information regarding the manipulations
are written into the \emph{$events} array in chronological order. Furthermore, some additional
information is also saved in the log, which might be needed for further analysis.
}
\examples{
\dontrun{
 #Image will be croped to smallest bounding box, and smallest values will be changed to NA,
 while 1024 will be substracted from all other data points.
 RIA_image <- load_dicom("C://Users//Test//Documents//Radiomics//John_Smith//DICOM_folder//")
 }
}

