/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.ipc.metrics.RpcDetailedActivityMBean;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsRecord;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.Updater;
import org.apache.hadoop.metrics.util.MetricsBase;
import org.apache.hadoop.metrics.util.MetricsRegistry;
import org.apache.hadoop.metrics.util.MetricsTimeVaryingRate;

public class RpcDetailedMetrics
implements Updater {
    public final MetricsRegistry registry = new MetricsRegistry();
    private final MetricsRecord metricsRecord;
    private static final Log LOG = LogFactory.getLog(RpcDetailedMetrics.class);
    RpcDetailedActivityMBean rpcMBean;
    final MetricsTimeVaryingRate getProtocolVersion = new MetricsTimeVaryingRate("getProtocolVersion", this.registry);

    public RpcDetailedMetrics(String hostName, String port) {
        MetricsContext context = MetricsUtil.getContext("rpc");
        this.metricsRecord = MetricsUtil.createRecord(context, "detailed-metrics");
        this.metricsRecord.setTag("port", port);
        LOG.info((Object)("Initializing RPC Metrics with hostName=" + hostName + ", port=" + port));
        context.registerUpdater(this);
        this.rpcMBean = new RpcDetailedActivityMBean(this.registry, hostName, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpdates(MetricsContext context) {
        RpcDetailedMetrics rpcDetailedMetrics = this;
        synchronized (rpcDetailedMetrics) {
            for (MetricsBase m : this.registry.getMetricsList()) {
                m.pushMetric(this.metricsRecord);
            }
        }
        this.metricsRecord.update();
    }

    public void shutdown() {
        if (this.rpcMBean != null) {
            this.rpcMBean.shutdown();
        }
    }
}

