/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.server.tasktracker;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TaskController;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.mapreduce.JobID;

public class Localizer {
    static final Log LOG = LogFactory.getLog(Localizer.class);
    private FileSystem fs;
    private String[] localDirs;
    private TaskController taskController;
    private Map<String, AtomicBoolean> localizedUsers = new HashMap<String, AtomicBoolean>();

    public Localizer(FileSystem fileSys, String[] lDirs, TaskController tc) {
        this.fs = fileSys;
        this.localDirs = lDirs;
        this.taskController = tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeUserDirs(String user) throws IOException {
        AtomicBoolean localizedUser;
        if (user == null) {
            throw new IOException("User is null. Cannot initialized user-directories.");
        }
        Object object = this.localizedUsers;
        synchronized (object) {
            if (!this.localizedUsers.containsKey(user)) {
                this.localizedUsers.put(user, new AtomicBoolean(false));
            }
            localizedUser = this.localizedUsers.get(user);
        }
        object = localizedUser;
        synchronized (object) {
            if (localizedUser.get()) {
                LOG.info((Object)("User-directories for the user " + user + " are already initialized on this TT. Not doing anything."));
                return;
            }
            LOG.info((Object)("Initializing user " + user + " on this TT."));
            boolean userDirStatus = false;
            boolean jobCacheDirStatus = false;
            boolean distributedCacheDirStatus = false;
            for (String localDir : this.localDirs) {
                Path userDir = new Path(localDir, TaskTracker.getUserDir(user));
                if (this.fs.exists(userDir) || this.fs.mkdirs(userDir)) {
                    PermissionsHandler.setPermissions(new File(userDir.toUri().getPath()), PermissionsHandler.sevenZeroZero);
                    userDirStatus = true;
                    File jobCacheDir = new File(localDir, TaskTracker.getJobCacheSubdir(user));
                    if (jobCacheDir.exists() || jobCacheDir.mkdirs()) {
                        PermissionsHandler.setPermissions(jobCacheDir, PermissionsHandler.sevenZeroZero);
                        jobCacheDirStatus = true;
                    } else {
                        LOG.warn((Object)("Unable to create job cache directory : " + jobCacheDir.getPath()));
                    }
                    File distributedCacheDir = new File(localDir, TaskTracker.getPrivateDistributedCacheDir(user));
                    if (distributedCacheDir.exists() || distributedCacheDir.mkdirs()) {
                        PermissionsHandler.setPermissions(distributedCacheDir, PermissionsHandler.sevenZeroZero);
                        distributedCacheDirStatus = true;
                        continue;
                    }
                    LOG.warn((Object)("Unable to create distributed-cache directory : " + distributedCacheDir.getPath()));
                    continue;
                }
                LOG.warn((Object)("Unable to create the user directory : " + userDir));
            }
            if (!userDirStatus) {
                throw new IOException("Not able to initialize user directories in any of the configured local directories for user " + user);
            }
            if (!jobCacheDirStatus) {
                throw new IOException("Not able to initialize job-cache directories in any of the configured local directories for user " + user);
            }
            if (!distributedCacheDirStatus) {
                throw new IOException("Not able to initialize distributed-cache directories in any of the configured local directories for user " + user);
            }
            TaskController.InitializationContext context = new TaskController.InitializationContext();
            context.user = user;
            context.workDir = null;
            this.taskController.initializeUser(context);
            localizedUser.set(true);
        }
    }

    public void initializeJobDirs(String user, JobID jobId) throws IOException {
        boolean initJobDirStatus = false;
        String jobDirPath = TaskTracker.getLocalJobDir(user, jobId.toString());
        for (String localDir : this.localDirs) {
            boolean jobDirStatus;
            Path jobDir = new Path(localDir, jobDirPath);
            if (this.fs.exists(jobDir)) {
                this.fs.delete(jobDir, true);
            }
            if (!(jobDirStatus = this.fs.mkdirs(jobDir))) {
                LOG.warn((Object)("Not able to create job directory " + jobDir.toString()));
            }
            initJobDirStatus = initJobDirStatus || jobDirStatus;
            PermissionsHandler.setPermissions(new File(jobDir.toUri().getPath()), PermissionsHandler.sevenZeroZero);
        }
        if (!initJobDirStatus) {
            throw new IOException("Not able to initialize job directories in any of the configured local directories for job " + jobId.toString());
        }
    }

    public void initializeAttemptDirs(String user, String jobId, String attemptId, boolean isCleanupAttempt) throws IOException {
        boolean initStatus = false;
        String attemptDirPath = TaskTracker.getLocalTaskDir(user, jobId, attemptId, isCleanupAttempt);
        for (String localDir : this.localDirs) {
            Path localAttemptDir = new Path(localDir, attemptDirPath);
            boolean attemptDirStatus = this.fs.mkdirs(localAttemptDir);
            if (!attemptDirStatus) {
                LOG.warn((Object)("localAttemptDir " + localAttemptDir.toString() + " couldn't be created."));
            }
            initStatus = initStatus || attemptDirStatus;
        }
        if (!initStatus) {
            throw new IOException("Not able to initialize attempt directories in any of the configured local directories for the attempt " + attemptId);
        }
    }

    public void initializeJobLogDir(JobID jobId) {
        boolean ret;
        File jobUserLogDir = TaskLog.getJobDir(jobId);
        if (!jobUserLogDir.exists() && !(ret = jobUserLogDir.mkdirs())) {
            LOG.warn((Object)("Could not create job user log directory: " + jobUserLogDir));
            return;
        }
        PermissionsHandler.setPermissions(jobUserLogDir, PermissionsHandler.sevenZeroZero);
    }

    public static class PermissionsHandler {
        public static final PermissionsInfo sevenFiveFive = new PermissionsInfo(true, true, true, false, true, false);
        public static final PermissionsInfo sevenZeroZero = new PermissionsInfo(true, true, true, true, true, true);

        public static boolean setPermissions(File f, PermissionsInfo pInfo) {
            if (pInfo == null) {
                LOG.debug((Object)" PermissionsInfo is null, returning.");
                return true;
            }
            LOG.debug((Object)("Setting permission for " + f.getAbsolutePath()));
            boolean ret = true;
            ret = f.setReadable(false, false) && ret;
            ret = f.setWritable(false, false) && ret;
            ret = f.setExecutable(false, false) && ret;
            ret = f.setReadable(pInfo.readPermissions, pInfo.readPermsOwnerOnly);
            LOG.debug((Object)("Readable status for " + f + " set to " + ret));
            ret = f.setWritable(pInfo.writePermissions, pInfo.writePermsOwnerOnly) && ret;
            LOG.debug((Object)("Writable status for " + f + " set to " + ret));
            ret = f.setExecutable(pInfo.executablePermissions, pInfo.executePermsOwnerOnly) && ret;
            LOG.debug((Object)("Executable status for " + f + " set to " + ret));
            return ret;
        }

        public static class PermissionsInfo {
            public boolean readPermissions;
            public boolean writePermissions;
            public boolean executablePermissions;
            public boolean readPermsOwnerOnly;
            public boolean writePermsOwnerOnly;
            public boolean executePermsOwnerOnly;

            public PermissionsInfo(boolean readPerms, boolean writePerms, boolean executePerms, boolean readOwnerOnly, boolean writeOwnerOnly, boolean executeOwnerOnly) {
                this.readPermissions = readPerms;
                this.writePermissions = writePerms;
                this.executablePermissions = executePerms;
                this.readPermsOwnerOnly = readOwnerOnly;
                this.writePermsOwnerOnly = writeOwnerOnly;
                this.executePermsOwnerOnly = executeOwnerOnly;
            }
        }
    }
}

