/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.ParameterInterface;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.util.MathUtils;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected long startTime;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(Parser parser, String string) {
        this.session = parser.getSession();
        this.sql = string;
        this.trace = this.session.getDatabase().getTrace("command");
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n) {
        throw DbException.get(90002);
    }

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled()) {
            this.startTime = System.currentTimeMillis();
        }
    }

    void setProgress(int n) {
        this.session.getDatabase().setProgress(n, this.sql, 0, 0);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    private void stop() {
        long l;
        Database database;
        this.session.endStatement();
        this.session.setCurrentCommand(null);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else if (this.session.getDatabase().isMultiThreaded() && (database = this.session.getDatabase()) != null && database.getLockMode() == 3) {
            this.session.unlockReadLocks();
        }
        if (this.trace.isInfoEnabled() && this.startTime > 0L && (l = System.currentTimeMillis() - this.startTime) > 100L) {
            this.trace.info("slow query: {0} ms", l);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultInterface executeQuery(int var1_1, boolean var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int executeUpdate() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long filterConcurrentUpdate(DbException dbException, long l) {
        long l2;
        if (dbException.getErrorCode() != 90131) {
            throw dbException;
        }
        long l3 = System.nanoTime() / 1000000L;
        if (l != 0L && l3 - l > (long)this.session.getLockTimeout()) {
            throw DbException.get(50200, dbException.getCause(), "");
        }
        Database database = this.session.getDatabase();
        int n = 1 + MathUtils.randomInt(10);
        do {
            try {
                if (database.isMultiThreaded()) {
                    Thread.sleep(n);
                    continue;
                }
                database.wait(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while ((l2 = System.nanoTime() / 1000000L - l3) < (long)n);
        return l == 0L ? l3 : l;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> arrayList = this.getParameters();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ParameterInterface parameterInterface = arrayList.get(i);
            parameterInterface.setValue(null, true);
        }
    }
}

