/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.h2.api.AggregateFunction;
import org.h2.command.Parser;
import org.h2.command.dml.Select;
import org.h2.engine.Session;
import org.h2.engine.UserAggregate;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class JavaAggregate
extends Expression {
    private final UserAggregate userAggregate;
    private final Select select;
    private AggregateFunction aggregate;
    private Expression[] args;
    private int[] argTypes;
    private int dataType;
    private Connection userConnection;
    private int lastGroupRowId;

    public JavaAggregate(UserAggregate userAggregate, Expression[] expressionArray, Select select) {
        this.userAggregate = userAggregate;
        this.args = expressionArray;
        this.select = select;
    }

    public int getCost() {
        int n = 5;
        for (Expression expression : this.args) {
            n += expression.getCost();
        }
        return n;
    }

    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public int getScale() {
        return DataType.getDataType((int)this.dataType).defaultScale;
    }

    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder();
        statementBuilder.append(Parser.quoteIdentifier(this.userAggregate.getName())).append('(');
        for (Expression expression : this.args) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append(')').toString();
    }

    public int getType() {
        return this.dataType;
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 2: {
                return false;
            }
            case 7: {
                expressionVisitor.addDependency(this.userAggregate);
                break;
            }
            case 1: {
                return false;
            }
        }
        for (Expression expression : this.args) {
            if (expression == null || expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i].mapColumns(columnResolver, n);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        this.userConnection = session.createConnection(false);
        this.argTypes = new int[this.args.length];
        int[] nArray = new int[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            int n;
            Expression expression = this.args[i];
            this.args[i] = expression.optimize(session);
            this.argTypes[i] = n = expression.getType();
            nArray[i] = DataType.convertTypeToSQLType(n);
        }
        this.aggregate = this.getInstance();
        this.dataType = DataType.convertSQLTypeToValueType(this.aggregate.getType(nArray));
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        for (Expression expression : this.args) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    private AggregateFunction getInstance() throws SQLException {
        AggregateFunction aggregateFunction = this.userAggregate.getInstance();
        aggregateFunction.init(this.userConnection);
        return aggregateFunction;
    }

    public Value getValue(Session session) throws SQLException {
        Object object;
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            throw Message.getSQLException(90054, this.getSQL());
        }
        AggregateFunction aggregateFunction = (AggregateFunction)hashMap.get(this);
        if (aggregateFunction == null) {
            aggregateFunction = this.getInstance();
        }
        if ((object = aggregateFunction.getResult()) == null) {
            return ValueNull.INSTANCE;
        }
        return DataType.convertToValue(session, object, this.dataType);
    }

    public void updateAggregate(Session session) throws SQLException {
        HashMap<Expression, Object> hashMap = this.select.getCurrentGroup();
        if (hashMap == null) {
            return;
        }
        int n = this.select.getCurrentGroupRowId();
        if (this.lastGroupRowId == n) {
            return;
        }
        this.lastGroupRowId = n;
        AggregateFunction aggregateFunction = (AggregateFunction)hashMap.get(this);
        if (aggregateFunction == null) {
            aggregateFunction = this.getInstance();
            hashMap.put(this, aggregateFunction);
        }
        Object[] objectArray = new Object[this.args.length];
        Object object = null;
        for (int i = 0; i < this.args.length; ++i) {
            Value value = this.args[i].getValue(session);
            value = value.convertTo(this.argTypes[i]);
            objectArray[i] = object = value.getObject();
        }
        if (this.args.length == 1) {
            aggregateFunction.add(object);
        } else {
            aggregateFunction.add(objectArray);
        }
    }
}

