% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateGremlinsModelHelperFunctions.R
\name{code_sawtooth_design}
\alias{code_sawtooth_design}
\title{Convert a Sawtooth Software generated design file to a dummy coded design
file}
\usage{
code_sawtooth_design(
  sawtooth_design,
  columns_to_code = c(4:ncol(sawtooth_design)),
  include_none_option = FALSE
)
}
\arguments{
\item{sawtooth_design}{A matrix that contains the Sawtooth design.  Can be
loaded with read.csv.}

\item{columns_to_code}{(Optional, Default = all columns) A vector listing the
numeric index of the columns to code. Note: The first column is column 4
due to the control variables}

\item{include_none_option}{(Optional, Default = FALSE) A boolean value
indicating whether to expand the task to include a none option}
}
\value{
A matrix object chat contains the dummy coded design file.  The last
  attribute is considered the reference level
}
\description{
Take a design file such as those generated by the Sawtooth Software
'Lighthouse Studio' and convert it into a dummy coded design file.  The last
level in the attribute is considered the reference level and will be dropped.
}
\details{
This function is written to not require converting columns to be factors. All
variables should be numeric indexes for the levels of the attributes. If you
would like to manually code a attribute of the design, for example if you
have a price variable, you must manually code that attribute and then can
call the function with the optional columns to code parameter.
}
\examples{
\dontrun{
 # Read in the Sawtooth Formatted data
 design <- read.csv("Design.csv")
 prices = c(0.79, 1.29, 1.79, 2.29, 2.79)
 design$price <- prices[design$price]
 codedDesign <- codeSawtoothDesignFile(design, c(4:9))
}


}
\seealso{
/url{http://www.sawtoothsoftware.com/help/lighthouse-studio/manual/index.html?hid_web_cbc_exporting.html}


Documentation for the Sawtooth Software Design file format can be found at
}
