% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_metadata.R
\docType{methods}
\name{set_metadata}
\alias{set_metadata}
\alias{set_metadata,joined_chrom,data.frame-method}
\alias{set_metadata,GCxGC-method}
\title{Set the metadata for a joined_chrom}
\usage{
set_metadata(Object, metadata)

\S4method{set_metadata}{joined_chrom,data.frame}(Object, metadata)
}
\arguments{
\item{Object}{a joined_chrom object}

\item{metadata}{a data.frame containing the metadata. It must have a column
named as \emph{Names} to merge with the chromatograms.}
}
\description{
`set_metadata` fill metadata slot of a joined_chrom object.
}
\examples{

GB08_fl <- system.file("extdata", "08GB.cdf", package = "RGCxGC")
GB09_fl <- system.file("extdata", "09GB.cdf", package = "RGCxGC")
GB08 <- read_chrom(GB08_fl, 5L)
GB09 <- read_chrom(GB09_fl, 5L)
extra_info <- data.frame(Names = c("GB08", "GB09"),
                       Type = c("Control", "Treatment"))
join_chrom <- join_chromatograms(GB08, GB09)
join_metadata <- set_metadata(join_chrom, metadata = extra_info)
}
