% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filters.R
\name{get_filter}
\alias{get_filter}
\title{Gets a filter to which the user has access to}
\usage{
get_filter(account.id, filter.id, token)
}
\arguments{
\item{account.id}{integer or character. Account ID to retrieve filters for.}

\item{filter.id}{integer or character. Filter ID to retrieve filters for.}

\item{token}{\code{\link[httr]{Token2.0}} class object with a valid authorization data.}
}
\value{
An Analytics account filter.
\item{id}{Filter ID.}
\item{kind}{Resource type for Analytics filter.}
\item{self.link}{Link for this filter.}
\item{account.id}{Account ID to which this filter belongs.}
\item{name}{Name of this filter.}
\item{type}{Type of this filter.}
\item{created}{Time this filter was created.}
\item{updated}{Time this filter was last modified.}
\item{parent.link.type}{Value is "analytics#account".}
\item{parent.link.href}{Link to the account to which this filter belongs.}
\item{include.details.kind}{Kind value for filter expression}
\item{include.details.field}{Field to filter.}
\item{include.details.match.type}{Match type for this filter.}
\item{include.details.expression.value}{Filter expression value}
\item{include.details.case.sensitive}{Determines if the filter is case sensitive.}
\item{exclude.details.kind}{Kind value for filter expression}
\item{exclude.details.field}{Field to filter.}
\item{exclude.details.match.type}{Match type for this filter.}
\item{exclude.details.expression.value}{Filter expression value}
\item{exclude.details.case.sensitive}{Determines if the filter is case sensitive.}
\item{lowercase.details.field}{Field to use in the filter.}
\item{uppercase.details.field}{Field to use in the filter.}
\item{search.and.replace.details.field}{Field to use in the filter.}
\item{search.and.replace.details.search.string}{Term to search.}
\item{search.and.replace.details.replace.string}{Term to replace the search term with.}
\item{search.and.replace.details.case.sensitive}{Determines if the filter is case sensitive.}
\item{advanced.details.field.a}{Field A.}
\item{advanced.details.extract.a}{Expression to extract from field A.}
\item{advanced.details.field.b}{Field B.}
\item{advanced.details.extract.b}{Expression to extract from field B.}
\item{advanced.details.output.to.field}{Output field.}
\item{advanced.details.output.constructor}{Expression used to construct the output value.}
\item{advanced.details.field.aRequired}{Indicates if field A is required to match.}
\item{advanced.details.field.bRequired}{Indicates if field B is required to match.}
\item{advanced.details.override.output.field}{Indicates if the existing value of the output field, if any, should be overridden by the output expression.}
\item{advanced.details.case.sensitive}{Indicates if the filter expressions are case sensitive.}
}
\description{
Gets a filter to which the user has access to
}
\references{
\href{https://developers.google.com/analytics/devguides/config/mgmt/v3/mgmtReference/management/filters}{Management API - Filters}
}
\seealso{
\code{\link{authorize}}

Other Management API: \code{\link{get_custom_dimension}};
  \code{\link{get_custom_metric}};
  \code{\link{get_experiment}}; \code{\link{get_goal}};
  \code{\link{get_profile}};
  \code{\link{get_unsampled_report}};
  \code{\link{get_upload}}; \code{\link{get_webproperty}};
  \code{\link{list_accounts}};
  \code{\link{list_custom_dimensions}};
  \code{\link{list_custom_metrics}};
  \code{\link{list_custom_sources}};
  \code{\link{list_experiments}};
  \code{\link{list_filters}}; \code{\link{list_goals}};
  \code{\link{list_profiles}}; \code{\link{list_segments}};
  \code{\link{list_unsampled_reports}};
  \code{\link{list_uploads}};
  \code{\link{list_webproperties}}
}

