/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.pete;

import edu.ucsb.cs.jicos.applications.branchandbound.Q;
import edu.ucsb.cs.jicos.applications.branchandbound.Solution;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.pete.TSP;
import edu.ucsb.cs.jicos.applications.utilities.graph.Edge;
import edu.ucsb.cs.jicos.applications.utilities.set.MergeFindSet;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.Shared;
import edu.ucsb.cs.jicos.services.Task;
import java.util.ArrayList;
import java.util.Arrays;

public class TspSolution
implements Solution {
    static final int COMPLETE_THRESHOLD = 1;
    static final int ATOMIC = 13;
    private int[] nodes;
    private int length;
    private int partialTourCost;
    private int mstCost;
    private int lowerBound;
    private boolean symmetric = true;
    private boolean equivalenceUnknown = true;

    TspSolution(TspSolution tspSolution, int n) {
        this.nodes = new int[tspSolution.nodes.length];
        System.arraycopy(tspSolution.nodes, 0, this.nodes, 0, tspSolution.nodes.length);
        this.length = tspSolution.length;
        this.partialTourCost = tspSolution.partialTourCost;
        this.equivalenceUnknown = tspSolution.equivalenceUnknown;
        if (this.equivalenceUnknown && this.nodes[n] == 1) {
            this.equivalenceUnknown = false;
        }
        int n2 = this.nodes[this.length];
        this.nodes[this.length++] = this.nodes[n];
        this.nodes[n] = n2;
    }

    public TspSolution(int n) {
        this.nodes = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.nodes[n2] = n2;
            ++n2;
        }
        this.length = 1;
        this.partialTourCost = 0;
    }

    public void computeLowerBound(Object object) {
        this.partialTourCost += ((TSP)object).distance[this.nodes[this.length - 2]][this.nodes[this.length - 1]];
        if (this.isComplete()) {
            ++this.length;
            this.partialTourCost += ((TSP)object).distance[this.nodes[this.nodes.length - 2]][this.nodes[this.nodes.length - 1]];
            this.partialTourCost += ((TSP)object).distance[this.nodes[this.nodes.length - 1]][0];
            this.lowerBound = this.partialTourCost;
        } else {
            int[][] nArray = ((TSP)object).distance;
            int[][] nArray2 = this.getExcludedSubgraph(nArray);
            ArrayList[] arrayListArray = this.getMinSpanningTree(nArray2);
            this.mstCost = this.getMstCost(arrayListArray, nArray2);
            this.lowerBound = this.partialTourCost + this.mstCost;
        }
    }

    public Q getChildren(Environment environment) {
        Object object = environment.getInput();
        Shared shared = environment.getShared();
        Q q = new Q();
        int n = this.length;
        while (n < this.nodes.length) {
            if (!this.symmetric || !this.equivalenceUnknown || this.nodes[n] != 2) {
                TspSolution tspSolution = new TspSolution(this, n);
                tspSolution.computeLowerBound(object);
                int n2 = (Integer)shared.get();
                if (tspSolution.lowerBound <= n2) {
                    q.add(tspSolution);
                }
            }
            ++n;
        }
        return q;
    }

    public int getCost() {
        return this.lowerBound;
    }

    private int[][] getExcludedSubgraph(int[][] nArray) {
        int n = this.nodes.length - this.length + 1;
        if (this.length > 1) {
            ++n;
        }
        int[] nArray2 = new int[n];
        int n2 = 0;
        nArray2[n2++] = 0;
        if (this.length > 1) {
            nArray2[n2++] = this.nodes[this.length - 1];
        }
        int n3 = this.length;
        while (n3 < this.nodes.length) {
            nArray2[n2++] = this.nodes[n3];
            ++n3;
        }
        int[][] nArray3 = new int[n][n];
        int n4 = 0;
        while (n4 < n) {
            nArray3[n4][n4] = 0;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray[nArray2[n4]][nArray2[n5]];
                nArray3[n5][n4] = n6;
                nArray3[n4][n5] = n6;
                ++n5;
            }
            ++n4;
        }
        nArray3[1][0] = 1000;
        nArray3[0][1] = 1000;
        return nArray3;
    }

    public int getLowerBound(Object object) {
        return this.lowerBound;
    }

    private ArrayList[] getMinSpanningTree(int[][] nArray) {
        int n;
        int n2 = nArray.length;
        ArrayList[] arrayListArray = new ArrayList[n2];
        Object[] objectArray = new Edge[n2 * (n2 - 1) / 2];
        MergeFindSet mergeFindSet = new MergeFindSet(nArray.length);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n = 0;
            while (n < n3) {
                Edge edge = new Edge(n3, n, nArray[n3][n]);
                objectArray[n4++] = edge;
                ++n;
            }
            ++n3;
        }
        Arrays.sort(objectArray);
        n = 0;
        while (n < n2) {
            arrayListArray[n] = new ArrayList();
            ++n;
        }
        int n5 = 0;
        int n6 = n2;
        while (n6 > 1) {
            int n7;
            Object object = objectArray[n5];
            int n8 = ((Edge)object).getU();
            int n9 = ((Edge)object).getV();
            int n10 = mergeFindSet.find(n8);
            if (n10 != (n7 = mergeFindSet.find(n9))) {
                mergeFindSet.merge(n10, n7);
                --n6;
                arrayListArray[n8].add(new Integer(n9));
                arrayListArray[n9].add(new Integer(n8));
            }
            ++n5;
        }
        return arrayListArray;
    }

    private int getMstCost(ArrayList[] arrayListArray, int[][] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < arrayListArray.length) {
            int n3 = 0;
            while (n3 < arrayListArray[n2].size()) {
                int n4 = (Integer)arrayListArray[n2].get(n3);
                n += nArray[n2][n4];
                ++n3;
            }
            ++n2;
        }
        return n / 2;
    }

    public boolean isAtomic(Task task) {
        return this.nodes.length - this.length < 13;
    }

    public boolean isComplete() {
        return this.nodes.length - this.length <= 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Size: " + this.nodes.length + ", tour size: " + this.length);
        stringBuffer.append(", cost: " + this.lowerBound + ", Tour: ");
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(" ").append(this.nodes[n]);
            ++n;
        }
        return new String(stringBuffer);
    }
}

