/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view.plotter;

import freak.core.view.swingsupport.FreakScrollBarAdjustmentListener;
import freak.module.view.plotter.AbstractPlotterPanel;
import freak.module.view.plotter.Plotter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

public class ExpandingPlotterPanel
extends AbstractPlotterPanel {
    JPanel scrollClient;
    JScrollPane scrollPane;

    public ExpandingPlotterPanel(Plotter plotter) {
        super(plotter);
        this.setBackground(Color.white);
        this.xAxis = new ExpandingXAxis();
        this.xAxis.setPreferredSize(new Dimension(100, 25));
        this.yAxis = new AbstractPlotterPanel.YAxis();
        this.yAxis.setPreferredSize(new Dimension(40, 100));
        this.plotArea = new AbstractPlotterPanel.PlotArea(this.xAxis, this.yAxis);
        this.scrollClient = new MyScrollClient();
        this.scrollClient.setLayout(new BorderLayout());
        this.scrollClient.add((Component)this.xAxis, "South");
        this.scrollClient.add((Component)this.plotArea, "Center");
        this.scrollClient.setBackground(Color.white);
        this.scrollPane = new JScrollPane(this.scrollClient);
        this.scrollPane.setRowHeaderView(this.yAxis);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(new FreakScrollBarAdjustmentListener(this.scrollPane.getHorizontalScrollBar(), true));
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.yAxis, "West");
        this.flush();
    }

    public void flush() {
        this.scrollClient.setPreferredSize(new Dimension((int)((double)(this.view.xAxisMax - this.view.xAxisMin) * this.view.constantGenXSpace), this.scrollClient.getHeight()));
        this.scrollClient.revalidate();
        this.repaint();
    }

    int computeDisplayXCoordinate(int x) {
        return (int)((double)(x - this.view.xAxisMin) * this.view.constantGenXSpace);
    }

    public int getStartingGenerations() {
        if (this.view.getPropertyNumberOfDisplayedValues() == 0) {
            return (int)((double)this.scrollPane.getWidth() / this.view.constantGenXSpace) + 1;
        }
        return this.view.getPropertyNumberOfDisplayedValues();
    }

    class ExpandingXAxis
    extends AbstractPlotterPanel.XAxis {
        ExpandingXAxis() {
        }

        void computeVisibleBounds() {
            Rectangle visibleBounds = this.graphics.getClipBounds();
            this.minVisibleX = ExpandingPlotterPanel.this.view.xAxisMin + (int)((double)((int)visibleBounds.getMinX()) / ExpandingPlotterPanel.this.view.constantGenXSpace);
            this.maxVisibleX = Math.min((int)((double)((int)visibleBounds.getMaxX()) / ExpandingPlotterPanel.this.view.constantGenXSpace) + 1 + ExpandingPlotterPanel.this.view.xAxisMin, ExpandingPlotterPanel.this.view.xAxisMax);
            this.minVisibleX = Math.max(ExpandingPlotterPanel.this.view.xAxisMin, this.minVisibleX - this.xGenStepWidth);
            this.maxVisibleX = Math.min(ExpandingPlotterPanel.this.view.xAxisMax, this.maxVisibleX + this.xGenStepWidth);
        }
    }

    class ExpandingPlotArea
    extends AbstractPlotterPanel.PlotArea {
        public ExpandingPlotArea(AbstractPlotterPanel.XAxis xAxis, AbstractPlotterPanel.YAxis yAxis) {
            super(xAxis, yAxis);
        }

        void computeVisibleBounds() {
            Rectangle visibleBounds = this.graphics.getClipBounds();
            this.minVisibleX = (int)((double)((int)visibleBounds.getMinX()) / ExpandingPlotterPanel.this.view.constantGenXSpace);
            this.maxVisibleX = Math.min((int)((double)((int)visibleBounds.getMaxX()) / ExpandingPlotterPanel.this.view.constantGenXSpace) + 1, ExpandingPlotterPanel.this.view.xAxisMax);
        }
    }

    class MyScrollClient
    extends JPanel
    implements Scrollable {
        MyScrollClient() {
        }

        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return ExpandingPlotterPanel.this.xAxis.xGenStepWidth;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (int)visibleRect.getWidth();
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

