/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.runframe;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class FreakDesktopPane {
    private JDesktopPane delegate = new JDesktopPane();
    private Set frames = new HashSet();

    public FreakDesktopPane() {
        this.delegate.setMinimumSize(new Dimension(100, 100));
        this.delegate.setPreferredSize(new Dimension(100, 100));
    }

    public JDesktopPane getDelegate() {
        return this.delegate;
    }

    public void tile() {
        JInternalFrame[] frames = this.getAllFrames();
        ArrayList<JInternalFrame> frameList = new ArrayList<JInternalFrame>();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isVisible() && !frames[i].isIcon()) {
                try {
                    frames[i].setMaximum(false);
                    frameList.add(frames[i]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            ++i;
        }
        Insets insets = this.delegate.getInsets();
        Rectangle bounds = this.delegate.getBounds();
        this.tile(frameList, new Rectangle((int)bounds.getMinX() + insets.left, (int)bounds.getMinY() + insets.top, (int)bounds.getMaxX() - insets.right, (int)bounds.getMaxY() - insets.bottom));
    }

    private void tile(ArrayList frames, Rectangle area) {
        if (frames.size() == 0) {
            return;
        }
        if (frames.size() == 1) {
            JInternalFrame frame = (JInternalFrame)frames.get(0);
            frame.reshape((int)area.getMinX(), (int)area.getMinY(), (int)area.getWidth(), (int)area.getHeight());
        } else {
            Rectangle subArea2;
            Rectangle subArea1;
            int median;
            if (area.getWidth() >= area.getHeight()) {
                median = (int)area.getWidth() / 2;
                subArea1 = new Rectangle((int)area.getMinX(), (int)area.getMinY(), median, (int)area.getHeight());
                subArea2 = new Rectangle((int)(area.getMinX() + (double)median + 1.0), (int)area.getMinY(), (int)(area.getWidth() - (double)median), (int)area.getHeight());
            } else {
                median = (int)area.getHeight() / 2;
                subArea1 = new Rectangle((int)area.getMinX(), (int)area.getMinY(), (int)area.getWidth(), median);
                subArea2 = new Rectangle((int)area.getMinX(), (int)(area.getMinY() + (double)median + 1.0), (int)area.getWidth(), (int)(area.getHeight() - (double)median));
            }
            ArrayList subList1 = new ArrayList();
            ArrayList subList2 = new ArrayList();
            int i = 0;
            while (i < frames.size() / 2) {
                subList1.add(frames.get(i));
                ++i;
            }
            i = frames.size() / 2;
            while (i < frames.size()) {
                subList2.add(frames.get(i));
                ++i;
            }
            this.tile(subList1, subArea1);
            this.tile(subList2, subArea2);
        }
    }

    public void cascade() {
        Object[] frames = this.getAllFrames();
        Arrays.sort(frames);
        if (frames.length == 0) {
            return;
        }
        int xOffset = this.delegate.getInsets().left;
        int yOffset = this.delegate.getInsets().top;
        int pos = 0;
        int step = this.getFrameDistance((JInternalFrame)frames[0]);
        int i = 0;
        while (i < frames.length) {
            if (((Component)frames[i]).isVisible() && !((JInternalFrame)frames[i]).isIcon()) {
                try {
                    if (((JInternalFrame)frames[i]).isMaximum()) {
                        ((JInternalFrame)frames[i]).setMaximum(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                ((JInternalFrame)frames[i]).reshape(pos + xOffset, pos + yOffset, 400, 400);
                ((JInternalFrame)frames[i]).toFront();
                pos += step;
            }
            ++i;
        }
    }

    public int getFrameDistance(JInternalFrame frame) {
        return frame.getHeight() - frame.getRootPane().getHeight();
    }

    public void minimizeAll() {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            try {
                frames[i].setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void restoreAll() {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            try {
                frames[i].setVisible(true);
                frames[i].setIcon(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void closeAll() {
        JInternalFrame[] frames = this.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            frames[i].setVisible(false);
            ++i;
        }
    }

    public JInternalFrame[] getAllFrames() {
        return new ArrayList(this.frames).toArray(new JInternalFrame[this.frames.size()]);
    }

    public void remove(JInternalFrame frame) {
        this.delegate.remove(frame);
        this.frames.remove(frame);
    }

    public void removeAll() {
        this.delegate.removeAll();
        this.frames.clear();
    }

    public void add(JInternalFrame frame) {
        this.delegate.add(frame);
        this.frames.add(frame);
        int xOffset = this.delegate.getInsets().left;
        int yOffset = this.delegate.getInsets().top;
        int pos = this.getFrameDistance(frame) * (this.getAllFrames().length - 1);
        frame.reshape(xOffset + pos, yOffset + pos, 400, 400);
    }
}

