/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.EventInfo;
import freak.core.event.Event;
import freak.core.event.EventListener;
import freak.core.event.EventSource;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventController
implements Serializable {
    private HashMap events = new HashMap();

    public static Class getEventSourceClassFor(Class eventClass) {
        try {
            return Class.forName(String.valueOf(eventClass.getName()) + "Source");
        }
        catch (ClassNotFoundException e) {
            System.out.println("no source interface for event " + eventClass.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static Class getEventListenerClassFor(Class eventClass) {
        try {
            return Class.forName(String.valueOf(eventClass.getName()) + "Listener");
        }
        catch (ClassNotFoundException e) {
            System.out.println("no listener interface for event " + eventClass.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static Method getAddListenerMethodFor(EventInfo evt) {
        String evtClassName = evt.getEventType().getName();
        int idx = evtClassName.lastIndexOf(46);
        evtClassName = evtClassName.substring(idx + 1);
        String mthdName = "add" + evtClassName + "Listener";
        Class[] parameterTypes = new Class[]{EventController.getEventListenerClassFor(evt.getEventType())};
        try {
            return evt.getEventSource().getClass().getMethod(mthdName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            System.out.println("no addListener method for event " + evt.getEventType().getName() + " in object " + evt.getEventSource());
            e.printStackTrace();
            return null;
        }
    }

    public static Method getRemoveListenerMethodFor(EventInfo evt) {
        String evtClassName = evt.getEventType().getName();
        int idx = evtClassName.lastIndexOf(46);
        evtClassName = evtClassName.substring(idx + 1);
        String mthdName = "remove" + evtClassName + "Listener";
        Class[] parameterTypes = new Class[]{EventController.getEventListenerClassFor(evt.getEventType())};
        try {
            return evt.getEventSource().getClass().getMethod(mthdName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            System.out.println("no removeListener method for event " + evt.getEventType().getName() + " in object " + evt.getEventSource());
            e.printStackTrace();
            return null;
        }
    }

    private List createNewEventListFor(Object m) {
        ArrayList l = new ArrayList();
        this.events.put(m, l);
        return l;
    }

    public List getEventListFor(Object m) {
        return (List)this.events.get(m);
    }

    public List getStaticEventsFor(Object m) {
        List l = this.getEventListFor(m);
        ArrayList<EventInfo> returnList = new ArrayList<EventInfo>();
        if (l != null) {
            for (EventInfo evt : l) {
                if (!evt.isStatic()) continue;
                returnList.add(evt);
            }
        }
        return returnList;
    }

    public List getCustomizableEventsFor(Object m) {
        List l = this.getEventListFor(m);
        ArrayList<EventInfo> returnList = new ArrayList<EventInfo>();
        if (l != null) {
            for (EventInfo evt : l) {
                if (evt.isStatic()) continue;
                returnList.add(evt);
            }
        }
        return returnList;
    }

    public EventInfo getCustomizableEventFor(Object Object2, String eventName) {
        List l = this.getCustomizableEventsFor(Object2);
        for (EventInfo evt : l) {
            if (!evt.getEventName().equals(eventName)) continue;
            return evt;
        }
        return null;
    }

    public List getUnregisteredEvents() {
        ArrayList<EventInfo> resultList = new ArrayList<EventInfo>();
        Set entries = this.events.entrySet();
        for (Map.Entry entry : entries) {
            List eventList = (List)entry.getValue();
            for (EventInfo evt : eventList) {
                if (evt.isRegistered()) continue;
                resultList.add(evt);
            }
        }
        return resultList;
    }

    private void addEvent(EventListener m, String name, Class type, EventSource source, boolean isStatic) {
        if (type == null) {
            throw new NullPointerException("Not allowed to add an event of type null.");
        }
        if (!Event.class.isAssignableFrom(type)) {
            throw new ClassCastException("Event class is not an event.");
        }
        if (source != null && !EventController.getEventSourceClassFor(type).isAssignableFrom(source.getClass())) {
            throw new ClassCastException("Object " + source + " isn't a source for event " + type);
        }
        if (m != null && !EventController.getEventListenerClassFor(type).isAssignableFrom(m.getClass())) {
            throw new ClassCastException("Object " + m + " isn't a listener for event " + type);
        }
        List l = this.getEventListFor(m);
        if (l == null) {
            l = this.createNewEventListFor(m);
        } else {
            for (EventInfo ei : l) {
                if (ei.getEventType() != type || ei.getEventSource() != source) continue;
                System.out.println("!!! WARNING !!! Tried to add duplicate event for\n\tmodule (" + m + ") event (" + type + ") source (" + source + ") static:" + isStatic);
                return;
            }
        }
        EventInfo evt = new EventInfo(m, name, type, source, isStatic);
        l.add(evt);
    }

    public void addEvent(EventListener m, Class type, EventSource source) {
        this.addEvent(m, "", type, source, true);
    }

    public void addEvent(EventListener m, String name, Class type) {
        this.addEvent(m, name, type, null, false);
    }

    public void addEvent(EventListener m, String name, Class type, EventSource source) {
        this.addEvent(m, name, type, source, false);
    }

    public boolean allEventsAssignedFor(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                if (evt.getEventSource() != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allEventsAssigned() {
        Collection eventLists = this.events.values();
        for (List eventList : eventLists) {
            for (EventInfo evt : eventList) {
                if (evt.getEventSource() != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allEventsRegisteredFor(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                if (evt.isRegistered()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean allEventsRegistered() {
        Collection eventLists = this.events.values();
        for (List eventList : eventLists) {
            for (EventInfo evt : eventList) {
                if (evt.isRegistered()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasCustomizableEvents(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                if (evt.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStaticEvents(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                if (!evt.isStatic()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEventSource(Object m) {
        Collection eventLists = this.events.values();
        for (List eventList : eventLists) {
            for (EventInfo evt : eventList) {
                if (evt.getEventSource() == null || evt.getEventSource() != m) continue;
                return true;
            }
        }
        return false;
    }

    public void removeModule(Object m) {
        if (m != null) {
            this.unregisterEventsFor(m);
            this.replaceGlobalEventSource(m, null);
            this.events.remove(m);
        }
    }

    public void removeAllOfClass(Class c) {
        HashSet modules = new HashSet(this.events.keySet());
        for (Object m : modules) {
            if (!c.isAssignableFrom(m.getClass())) continue;
            this.removeModule(m);
        }
    }

    public void registerEventsFor(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                evt.register();
            }
        }
    }

    public void unregisterEventsFor(Object m) {
        List l = this.getEventListFor(m);
        if (l != null) {
            for (EventInfo evt : l) {
                evt.unregister();
            }
        }
    }

    public void registerAllEvents() {
        Set modules = this.events.keySet();
        for (Object m : modules) {
            this.registerEventsFor(m);
        }
    }

    public void unregisterAllEvents() {
        Set modules = this.events.keySet();
        for (Object m : modules) {
            this.unregisterEventsFor(m);
        }
    }

    public void replaceGlobalEventSource(Object oldSource, Object newSource) {
        Collection eventLists = this.events.values();
        for (List eventList : eventLists) {
            for (EventInfo evt : eventList) {
                if (evt.getEventSource() == null || evt.getEventSource() != oldSource) continue;
                evt.replaceEventSource((EventSource)newSource);
            }
        }
    }
}

