/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 06/28/2007
 */

package freak.gui.scheduleeditor;

import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.Module;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.gui.JButtonFactory;
import freak.gui.ModuleCheckBoxList;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;

/**
 * @author  Oliver, Dirk
 */
public class PanelStoppingCriterion extends ScheduleEditorPanel {

	/**
	 * @uml.property  name="stoppingCriteria"
	 * @uml.associationEnd  multiplicity="(0 -1)"
	 */
	private Module[] stoppingCriteria;

	/** Creates new JPanel */
	public PanelStoppingCriterion(ScheduleEditor scheduleEditor) {
		super(scheduleEditor);
		initComponents();

		listStoppingCriteria.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent arg0) {
				JCheckBox checkBox = ((ModuleCheckBoxList)listStoppingCriteria).getCheckBox(listStoppingCriteria.locationToIndex(arg0.getPoint()));
				checkBox.setSelected(!checkBox.isSelected()); 
				listStoppingCriteria.repaint();
			}
		});
	}

	public static String getDescription() {
		return "Select Stopping Criteria";
	}

	public String getHelpURL() {
		return "node4.html#SECTION00445000000000000000";
	}

	public void enter() {
		super.enter();
		stoppingCriteria = moduleCollector.getStoppingCriteria();
		((ModuleCheckBoxList)listStoppingCriteria).setModules(stoppingCriteria, schedule.getStoppingCriteria());
	}

	private void parse() {
		Module m = (StoppingCriterion)listStoppingCriteria.getSelectedValue();
		Util.displayText(taDescrStoppingCriterion, m.getDescription());
		if (m instanceof Configurable)
			Util.displayText(tfOptionsStoppingCriterion, ((Configurable)m).getConfiguration().getDescription());
		else
			Util.displayText(tfOptionsStoppingCriterion, "<not configurable>");
		buConfigStoppingCriterion.setEnabled(m instanceof Configurable);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() { //GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;

		jPanel10 = new javax.swing.JPanel();
		buConfigStoppingCriterion = JButtonFactory.newButton();
		jLabel15 = new javax.swing.JLabel();
		tfOptionsStoppingCriterion = new javax.swing.JTextField();
		jLabel28 = new javax.swing.JLabel();
		jScrollPane12 = new javax.swing.JScrollPane();
		listStoppingCriteria = new ModuleCheckBoxList();
		jScrollPane17 = new javax.swing.JScrollPane();
		taDescrStoppingCriterion = new javax.swing.JTextArea();
		jLabel29 = new javax.swing.JLabel();

		setLayout(new java.awt.GridBagLayout());

		setBorder(new javax.swing.border.TitledBorder("Select Stopping Criteria"));
		jPanel10.setLayout(new java.awt.GridBagLayout());

		buConfigStoppingCriterion.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
		buConfigStoppingCriterion.setMnemonic('o');
		buConfigStoppingCriterion.setText("Configure...");
		buConfigStoppingCriterion.setEnabled(false);
		buConfigStoppingCriterion.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent evt) {
				buConfigStoppingCriterionActionPerformed(evt);
			}
		});

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		jPanel10.add(buConfigStoppingCriterion, gridBagConstraints);

		jLabel15.setText("Options:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel10.add(jLabel15, gridBagConstraints);

		tfOptionsStoppingCriterion.setEditable(false);
		tfOptionsStoppingCriterion.setText("<no stopping criterion selected>");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 2;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		gridBagConstraints.weightx = 0.1;
		jPanel10.add(tfOptionsStoppingCriterion, gridBagConstraints);

		jLabel28.setText("Stopping Criteria:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel10.add(jLabel28, gridBagConstraints);

		jScrollPane12.setMinimumSize(new java.awt.Dimension(220, 0));
		jScrollPane12.setPreferredSize(new java.awt.Dimension(220, 0));
		listStoppingCriteria.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
		listStoppingCriteria.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
			public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
				listStoppingCriteriaValueChanged(evt);
			}
		});

		jScrollPane12.setViewportView(listStoppingCriteria);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridheight = 3;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		gridBagConstraints.weighty = 0.1;
		jPanel10.add(jScrollPane12, gridBagConstraints);

		taDescrStoppingCriterion.setEditable(false);
		taDescrStoppingCriterion.setLineWrap(true);
		taDescrStoppingCriterion.setText("<no stopping criterion selected>");
		taDescrStoppingCriterion.setWrapStyleWord(true);
		jScrollPane17.setViewportView(taDescrStoppingCriterion);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 1;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.1;
		jPanel10.add(jScrollPane17, gridBagConstraints);

		jLabel29.setText("Description:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 0;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		jPanel10.add(jLabel29, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
		gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
		gridBagConstraints.weightx = 0.1;
		gridBagConstraints.weighty = 0.1;
		add(jPanel10, gridBagConstraints);

	} //GEN-END:initComponents

	private void buConfigStoppingCriterionActionPerformed(java.awt.event.ActionEvent evt) { //GEN-FIRST:event_buConfigStoppingCriterionActionPerformed
		String s = Util.configureModule(scheduleEditor, (StoppingCriterion)listStoppingCriteria.getSelectedValue(), schedule);
		if (s != null)
			Util.displayText(tfOptionsStoppingCriterion, s);
		scheduleDependencyChecker.processNewModuleConfiguration((StoppingCriterion)listStoppingCriteria.getSelectedValue());
		scheduleEditor.updateComponents();
	} //GEN-LAST:event_buConfigStoppingCriterionActionPerformed

	private void listStoppingCriteriaValueChanged(javax.swing.event.ListSelectionEvent evt) { //GEN-FIRST:event_listStoppingCriteriaValueChanged
		if (evt.getValueIsAdjusting())
			return;
			
		StoppingCriterion[] oldObj = schedule.getStoppingCriteria();
		Object[] objects = ((ModuleCheckBoxList)listStoppingCriteria).getCheckedValues();
		StoppingCriterion[] newObj = null;
		
		if (objects != null) {
			newObj = new StoppingCriterion[objects.length];
			System.arraycopy(objects, 0, newObj, 0, objects.length);
		}

		boolean different = false;
		if (oldObj != null && newObj != null && oldObj.length == newObj.length) {
			for (int i = 0; i < oldObj.length; i++) {
				if (oldObj[i] != newObj[i]) different = true;
			}
		} else different = true;

		if (different) {
			if (oldObj != null) {
				for (int i = 0; i < oldObj.length; i++) {
					eventController.removeModule(oldObj[i]);
				}
			}
			schedule.setStoppingCriteria(newObj);
			scheduleDependencyChecker.processNewStoppingCriterion();
			for (int i = 0; i < newObj.length; i++) {
				newObj[i].createEvents();
			}
			scheduleEditor.updateComponents();
		}
		parse();
	} //GEN-LAST:event_listStoppingCriteriaValueChanged

	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton buConfigStoppingCriterion;
	private javax.swing.JLabel jLabel15;
	private javax.swing.JLabel jLabel28;
	private javax.swing.JLabel jLabel29;
	private javax.swing.JPanel jPanel10;
	private javax.swing.JScrollPane jScrollPane12;
	private javax.swing.JScrollPane jScrollPane17;
	private javax.swing.JList listStoppingCriteria;
	private javax.swing.JTextArea taDescrStoppingCriterion;
	private javax.swing.JTextField tfOptionsStoppingCriterion;
	// End of variables declaration//GEN-END:variables

}
