/*
 * This file is part of RFrEAK. For licensing and copyright information
 * please see the file COPYING in the root directory of this
 * distribution or contact <robin.nunkesser@udo.edu>.
 * 
 * This file is a modification of the original file distributed with
 * FrEAK (http://sourceforge.net/projects/freak427/).
 * Last modification: 06/28/2007
 */

package freak.gui.runframe;

import freak.core.control.*;
import freak.core.view.swingsupport.*;
import freak.gui.*;

/**
 * Autogenerated Panel.
 * @author  Stefan
 */
public class InfoPanel extends javax.swing.JPanel {
	private FreakSpinnerModel batchSpinnerModel;
	private FreakSpinnerModel runSpinnerModel;
	private FreakSpinnerModel generationSpinnerModel;

	/** Creates new form InfoPanel */
	public InfoPanel() {
		initComponents();
		initSpinners();

		jLabelRun.setLabelFor(jSpinnerRun);
		jLabelGeneration.setLabelFor(jSpinnerGeneration);
		jLabelSpeedLimit.setLabelFor(jTextFieldSpeedLimit);
		
		jLabelSpeedLimit.setVisible(false);
		//jButtonStartStop.setVisible(false);
		jCheckBoxSpeedLimit.setVisible(false);
		jSpinnerGeneration.setVisible(false);
		jTextFieldSpeedLimit.setVisible(false);
		jLabelGeneration.setVisible(false);
		jLabelBatch.setVisible(false);
		jSpinnerBatch.setVisible(false);
		jSpinnerRun.setVisible(false);
		jLabelRun.setVisible(false);
	}

	private void initSpinners() {
		batchSpinnerModel = new FreakSpinnerModel();
		runSpinnerModel = new FreakSpinnerModel();
		generationSpinnerModel = new FreakSpinnerModel();

		batchSpinnerModel.setView(jSpinnerBatch);
		runSpinnerModel.setView(jSpinnerRun);
		generationSpinnerModel.setView(jSpinnerGeneration);
	}

	public void displayUpdate(ScheduleStatusData data) {
		synchronized (generationSpinnerModel) {
			generationSpinnerModel.setMaximum(data.lastReplayPointInCurrentRun.generation);
			generationSpinnerModel.setMinimum(data.currentTimeIndex.run == 0 ? 0 : 1);
			generationSpinnerModel.setValue(data.currentTimeIndex.generation);
		}
		UpdateManager.markDirty(generationSpinnerModel);

		synchronized (runSpinnerModel) {
			runSpinnerModel.setMaximum(data.lastPointInCurrentBatch.run);
			runSpinnerModel.setMinimum(data.currentTimeIndex.batch == 0 ? 0 : 1);
			runSpinnerModel.setValue(data.currentTimeIndex.run);
		}
		UpdateManager.markDirty(runSpinnerModel);

		synchronized (batchSpinnerModel) {
			batchSpinnerModel.setMaximum(data.lastReplayPoint.batch);
			batchSpinnerModel.setValue(data.currentTimeIndex.batch);
		}
		UpdateManager.markDirty(batchSpinnerModel);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	private void initComponents() { //GEN-BEGIN:initComponents
		java.awt.GridBagConstraints gridBagConstraints;

		jLabelRun = new javax.swing.JLabel();
		jButtonStartStop = JButtonFactory.newButton();
		jLabelGeneration = new javax.swing.JLabel();
		jTextFieldSpeedLimit = new javax.swing.JTextField();
		jLabelSpeedLimit = new javax.swing.JLabel();
		jSpinnerRun = new javax.swing.JSpinner();
		jSpinnerGeneration = new javax.swing.JSpinner();
		jCheckBoxSpeedLimit = new javax.swing.JCheckBox();
		jLabelBatch = new javax.swing.JLabel();
		jSpinnerBatch = new javax.swing.JSpinner();

		setLayout(new java.awt.GridBagLayout());

		setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(12, 12, 11, 11)));
		setMinimumSize(new java.awt.Dimension(150, 300));
		setPreferredSize(new java.awt.Dimension(170, 400));

		jLabelRun.setText("Run:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 4;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jLabelRun, gridBagConstraints);

		jButtonStartStop.setText("Start");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 10;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(17, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTH;
		gridBagConstraints.weightx = 1.0;
		gridBagConstraints.weighty = 1.0;
		add(jButtonStartStop, gridBagConstraints);

		jLabelGeneration.setText("Generation:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 6;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jLabelGeneration, gridBagConstraints);

		jTextFieldSpeedLimit.setHorizontalAlignment(javax.swing.JTextField.TRAILING);
		jTextFieldSpeedLimit.setText("10");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 1;
		gridBagConstraints.gridy = 9;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
		add(jTextFieldSpeedLimit, gridBagConstraints);

		jLabelSpeedLimit.setText("Speed Limit:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 8;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.insets = new java.awt.Insets(11, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jLabelSpeedLimit, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 5;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jSpinnerRun, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 7;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jSpinnerGeneration, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 9;
		gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 5);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jCheckBoxSpeedLimit, gridBagConstraints);

		jLabelBatch.setText("Batch:");
		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 2;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.insets = new java.awt.Insets(24, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jLabelBatch, gridBagConstraints);

		gridBagConstraints = new java.awt.GridBagConstraints();
		gridBagConstraints.gridx = 0;
		gridBagConstraints.gridy = 3;
		gridBagConstraints.gridwidth = 2;
		gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
		gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
		gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
		add(jSpinnerBatch, gridBagConstraints);

	} //GEN-END:initComponents

	// Variables declaration - do not modify//GEN-BEGIN:variables
	javax.swing.JLabel jLabelSpeedLimit;
	javax.swing.JButton jButtonStartStop;
	javax.swing.JCheckBox jCheckBoxSpeedLimit;
	javax.swing.JSpinner jSpinnerGeneration;
	javax.swing.JTextField jTextFieldSpeedLimit;
	javax.swing.JLabel jLabelGeneration;
	javax.swing.JLabel jLabelBatch;
	javax.swing.JSpinner jSpinnerBatch;
	javax.swing.JSpinner jSpinnerRun;
	javax.swing.JLabel jLabelRun;
	// End of variables declaration//GEN-END:variables

}
