/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.view.SingleIndividualView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.module.fitness.permutation.NQueensProblem;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class NQueensView
extends SingleIndividualView
implements FreakSwingModel {
    public NQueensView(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getRealFitnessFunction() instanceof NQueensProblem)) {
            throw new UnsupportedEnvironmentException("Does only work with the fitness NQueensProblem");
        }
    }

    public JPanel createIndividualPanel() {
        return new ChessBoardPanel(this);
    }

    public String getName() {
        return "N Queens View";
    }

    public String getDescription() {
        return "Shows a NxN chess board with the N queens.";
    }

    class ChessBoardPanel
    extends JPanel {
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private NQueensView view;

        public ChessBoardPanel(NQueensView view) {
            this.view = view;
            this.setOpaque(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            int n = ((Permutation)NQueensView.this.getSchedule().getGenotypeSearchSpace()).getDimension();
            int i = 0;
            while (i < n) {
                int j = 0;
                while (j < n) {
                    this.graphics.setColor((i + j) % 2 == 0 ? Color.black : Color.white);
                    Rectangle rect = this.getField(i, j);
                    this.graphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                    ++j;
                }
                ++i;
            }
            if (NQueensView.this.getIndividualToDisplay() != null) {
                NQueensView nQueensView = this.view;
                synchronized (nQueensView) {
                    this.drawQueens(NQueensView.this.getIndividualToDisplay());
                }
            }
        }

        private void drawQueens(Individual individual) {
            int n = ((Permutation)NQueensView.this.getSchedule().getGenotypeSearchSpace()).getDimension();
            int[] perm = ((PermutationGenotype)individual.getGenotype()).getIntArray();
            int i = 0;
            while (i < n) {
                Rectangle rect = this.getField(i, perm[i] - 1);
                this.graphics.setColor(Color.red);
                this.graphics.fillOval(rect.x, rect.y, rect.width, rect.height);
                ++i;
            }
        }

        private Rectangle getField(int i, int j) {
            int n = ((Permutation)NQueensView.this.getSchedule().getGenotypeSearchSpace()).getDimension();
            int x = this.currentWidth * j / n;
            int y = this.currentHeight * i / n;
            return new Rectangle(x, y, this.currentWidth * (j + 1) / n - x, this.currentHeight * (i + 1) / n - y);
        }
    }
}

