/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;
import freak.module.fitness.generalstring.IsingModelTorus;
import freak.module.searchspace.GeneralStringGenotype;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IsingOnTorus
extends AbstractGenerationStoppingCriterion {
    private int[] gene;
    private int w;
    private int h;
    private int opt;
    private boolean horiz = false;
    private boolean vertical = false;
    private boolean diag1 = false;
    private int nrCut;
    private int[][] cut;
    private int[] ringSize;
    private boolean eightNeighbours;
    private String fileName;

    public IsingOnTorus(Schedule schedule) {
        super(schedule);
    }

    public void initialize() {
        super.initialize();
        try {
            this.opt = (int)Math.round(((IsingModelTorus)this.schedule.getFitnessFunction()).getOptimalFitnessValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof IsingModelTorus)) {
            throw new UnsupportedEnvironmentException("This module works on Ising Model Torus only.");
        }
    }

    public String getName() {
        return "Ising on Torus";
    }

    public String getDescription() {
        return "Stops a run if no islands or unstable rings are left.";
    }

    public void checkCriterion(GenerationEvent evt) {
        if (this.fileName == null) {
            this.fileName = "run.lst";
            File f = new File(this.fileName);
            try {
                f.delete();
                f.createNewFile();
            }
            catch (IOException e) {
                System.out.println("Can\u00a5t delete or create output file");
            }
        }
        if (this.getSchedule().getFitnessFunction() instanceof IsingModelTorus) {
            IsingModelTorus ff = (IsingModelTorus)this.getSchedule().getFitnessFunction();
            int height = ff.getPropertyTorusHeight();
            int width = ff.getPropertyTorusWidth();
            boolean edge = ff.getPropertyDiagonalEdges();
            if (height != this.h || width != this.w || edge != this.eightNeighbours) {
                String edges = ff.getPropertyDiagonalEdges() != false ? " with" : " without";
                this.write("Size of Torus : " + width + "x" + height + edges + " diagonal edges");
            }
        }
        IndividualList p = this.getSchedule().getPopulationManager().getPopulation();
        Individual ind = p.getIndividual(0);
        this.gene = ((GeneralStringGenotype)ind.getGenotype()).getIntArray();
        IsingModelTorus ff = (IsingModelTorus)this.getSchedule().getFitnessFunction();
        this.w = ff.getPropertyTorusWidth();
        this.h = ff.getPropertyTorusHeight();
        this.eightNeighbours = ff.getPropertyDiagonalEdges();
        double fitness = ff.evaluate(ind, p);
        if (fitness == (double)this.opt) {
            String output = "Run \t" + this.getSchedule().getCurrentRun() + "\t stopped" + " in generation \t" + this.getSchedule().getCurrentGeneration();
            System.out.println(output);
            this.write(output);
            this.stopRun();
            return;
        }
        boolean onlystableRings = this.onlystableRings();
        if (onlystableRings) {
            String output = "Run \t" + this.getSchedule().getCurrentRun() + "\t stopped " + "in generation \t" + this.getSchedule().getCurrentGeneration() + "\t : ";
            output = this.diag1 ? String.valueOf(output) + "diagonal \t(" : String.valueOf(output) + (this.horiz ? "horizontal" : "vertical") + " \t(";
            int i = 0;
            while (i < this.ringSize.length) {
                output = String.valueOf(output) + this.ringSize[i];
                if (i + 1 < this.ringSize.length) {
                    output = String.valueOf(output) + ",";
                }
                ++i;
            }
            output = String.valueOf(output) + ")";
            System.out.println(output);
            this.write(output);
            this.stopRun();
        }
    }

    private boolean onlystableRings() {
        int r = 0;
        while (r < this.h) {
            int c = 0;
            while (c < this.w) {
                boolean tempHoriz = false;
                boolean tempVertical = false;
                boolean tempDiag1 = false;
                boolean tempDiag2 = false;
                tempHoriz = this.gene[this.map(r, c)] == this.gene[this.map(r, c - 1)] && this.gene[this.map(r, c)] == this.gene[this.map(r, c + 1)];
                boolean bl = tempVertical = this.gene[this.map(r, c)] == this.gene[this.map(r - 1, c)] && this.gene[this.map(r, c)] == this.gene[this.map(r + 1, c)];
                if (this.eightNeighbours) {
                    tempDiag1 = this.gene[this.map(r, c)] == this.gene[this.map(r + 1, c - 1)] && this.gene[this.map(r, c)] == this.gene[this.map(r - 1, c + 1)];
                    boolean bl2 = tempDiag2 = this.gene[this.map(r, c)] == this.gene[this.map(r - 1, c - 1)] && this.gene[this.map(r, c)] == this.gene[this.map(r + 1, c + 1)];
                }
                if (!(tempHoriz || tempVertical || tempDiag1 || tempDiag2)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        if (this.eightNeighbours) {
            boolean vert1 = true;
            int r2 = 0;
            while (r2 < this.h) {
                if (this.gene[this.map(r2, 0)] != this.gene[this.map(r2 + 1, 0)]) {
                    vert1 = false;
                }
                ++r2;
            }
            boolean horiz2 = true;
            int c = 0;
            while (c < this.w) {
                if (this.gene[this.map(0, c)] != this.gene[this.map(0, c + 1)]) {
                    horiz2 = false;
                }
                ++c;
            }
            if (!vert1 && !horiz2) {
                this.diag1 = true;
                this.horiz = false;
                this.vertical = false;
            }
            if (vert1 && !horiz2) {
                this.horiz = false;
                this.diag1 = false;
                this.vertical = true;
            }
            if (!vert1 && horiz2) {
                this.vertical = false;
                this.diag1 = false;
                this.horiz = true;
            }
        } else {
            this.vertical = true;
            this.horiz = false;
            r = 0;
            while (r < this.h) {
                if (this.gene[this.map(r, 0)] != this.gene[this.map(r + 1, 0)]) {
                    this.vertical = false;
                    this.horiz = true;
                }
                ++r;
            }
        }
        if (this.horiz) {
            this.findVerticalCuts();
        }
        if (this.vertical) {
            this.findHorizontalCuts();
        }
        if (this.diag1) {
            if (this.w <= this.h) {
                this.findHorizontalCuts();
            } else {
                this.findVerticalCuts();
            }
        }
        this.calculateRingSizes();
        return true;
    }

    private void findVerticalCuts() {
        this.cut = new int[this.h][];
        this.nrCut = 0;
        this.cut[0] = new int[2];
        int r = 0;
        while (r < this.h) {
            if (this.gene[this.map(r, 0)] != this.gene[this.map(r + 1, 0)]) {
                this.cut[this.nrCut][1] = r;
                ++this.nrCut;
                this.cut[this.nrCut] = new int[2];
                this.cut[this.nrCut][0] = r + 1;
            }
            ++r;
        }
        this.cut[0][0] = this.gene[this.map(this.h - 1, 0)] == this.gene[this.map(0, 0)] ? this.cut[this.nrCut][0] : 0;
    }

    private void findHorizontalCuts() {
        this.nrCut = 0;
        this.cut[0] = new int[2];
        int c = 0;
        while (c < this.w) {
            if (this.gene[this.map(0, c)] != this.gene[this.map(0, c + 1)]) {
                this.cut[this.nrCut][1] = c;
                ++this.nrCut;
                this.cut[this.nrCut] = new int[2];
                this.cut[this.nrCut][0] = c + 1;
            }
            ++c;
        }
        this.cut[0][0] = this.gene[this.map(0, this.w - 1)] == this.gene[this.map(0, 0)] ? this.cut[this.nrCut][0] : 0;
    }

    private void calculateRingSizes() {
        int sum1 = 0;
        int sum2 = 0;
        int i = 0;
        while (i < this.nrCut / 2) {
            sum1 += this.dist(this.cut[2 * i][0], this.cut[2 * i][1]);
            ++i;
        }
        i = 0;
        while (i < this.nrCut / 2) {
            sum2 += this.dist(this.cut[2 * i + 1][0], this.cut[2 * i + 1][1]);
            ++i;
        }
        this.ringSize = new int[this.nrCut / 2];
        if (sum1 <= sum2) {
            i = 0;
            while (i < this.nrCut / 2) {
                this.ringSize[i] = this.dist(this.cut[2 * i][0], this.cut[2 * i][1]);
                ++i;
            }
        } else {
            i = 0;
            while (i < this.nrCut / 2) {
                this.ringSize[i] = this.dist(this.cut[2 * i + 1][0], this.cut[2 * i + 1][1]);
                ++i;
            }
        }
    }

    private int dist(int i, int j) {
        if (this.horiz) {
            if (i <= j) {
                return j - i + 1;
            }
            return this.h - i + j + 1;
        }
        if (i <= j) {
            return j - i + 1;
        }
        return this.w - i + j + 1;
    }

    private void write(String s) {
        try {
            File f = new File(this.fileName);
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            raf.seek(raf.length());
            raf.writeBytes(String.valueOf(s) + "\r");
            raf.close();
        }
        catch (IOException e) {
            System.out.println("Writing failed");
        }
    }

    private int map(int i, int j) {
        j %= this.w;
        if ((i %= this.h) < 0) {
            i += this.h;
        }
        if (j < 0) {
            j += this.w;
        }
        return i * this.w + j;
    }
}

