/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.common;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.searchspace.SearchSpace;
import freak.module.operator.crossover.MultiPairwiseCrossover;
import freak.module.searchspace.Cycle;
import freak.module.searchspace.Permutation;
import freak.module.searchspace.PermutationGenotype;

public class OrderCrossover2
extends MultiPairwiseCrossover
implements CompatibleWithDifferentSearchSpaces {
    public OrderCrossover2(OperatorGraph graph) {
        super(graph);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        SearchSpace searchspace = schedule.getGenotypeSearchSpace();
        if (!(searchspace instanceof Permutation) && !(searchspace instanceof Cycle)) {
            throw new UnsupportedEnvironmentException("Wrong searchspace");
        }
    }

    private int[] calculateInverse(int[] perm) {
        int[] inv = new int[perm.length];
        int i = 0;
        while (i < perm.length) {
            inv[perm[i] - 1] = i;
            ++i;
        }
        return inv;
    }

    protected Individual doCrossover(Individual ind1, Individual ind2) {
        RandomElement re = this.graph.getSchedule().getRandomElement();
        int[] gt1 = ((PermutationGenotype)ind1.getGenotype()).getIntArray();
        int[] gt2 = ((PermutationGenotype)ind2.getGenotype()).getIntArray();
        int[] newGt = new int[gt1.length];
        boolean[] marked = new boolean[gt1.length];
        int i = 0;
        while (i < gt1.length) {
            marked[i] = re.choose(1, 2) != 1;
            ++i;
        }
        int[] inv2 = this.calculateInverse(gt2);
        int nextMarkedPos = 0;
        while (!marked[nextMarkedPos]) {
            ++nextMarkedPos;
        }
        int i2 = 0;
        while (i2 < gt1.length) {
            boolean isMarked = marked[inv2[gt1[i2] - 1]];
            if (isMarked) {
                newGt[nextMarkedPos] = gt1[i2];
                if (nextMarkedPos < gt1.length - 1) {
                    ++nextMarkedPos;
                }
                while (!marked[nextMarkedPos] && nextMarkedPos < gt1.length - 1) {
                    ++nextMarkedPos;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < gt1.length) {
            if (!marked[i2]) {
                newGt[i2] = gt2[i2];
            }
            ++i2;
        }
        return new Individual(this.graph.getSchedule(), new PermutationGenotype(newGt), new Individual[]{ind1, ind2});
    }

    public String getDescription() {
        return "First k is chosen uniformly at random from {1,...,n-1} (n denotes the dimension of the search space). Then k randomly chosen positions are marked. These k positions are taken over from the second individual in the order in which they are in the first individual.\nExample: ind1 = 123456789, ind2 = 841593627, k=4, marked are the positions 2,4,6,8\nWe take from the second individual 4,5,3,2. The order of these elements in the first individual is 2,3,4,5. That's why the child is of the form ?2?3?4?5?. Now we add the remaining positions from ind2: 821394657.";
    }

    public String getName() {
        return "Order crossover-2";
    }
}

