/*
 * Decompiled with CFR 0.152.
 */
package freak.gui.graph;

import freak.core.graph.Finish;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.FreakPort;
import freak.core.graph.InPort;
import freak.core.graph.OutPort;
import freak.core.graph.Start;
import freak.gui.graph.EditorDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.BasicMarqueeHandler;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortView;

class FreakMarqueeHandler
extends BasicMarqueeHandler {
    protected EditorDialog editor;
    protected JGraph graph;
    protected Point start;
    protected Point current;
    protected PortView port;
    protected PortView firstPort;

    public FreakMarqueeHandler(JGraph graph, EditorDialog editor) {
        this.graph = graph;
        this.editor = editor;
    }

    public boolean isForceMarqueeEvent(MouseEvent e) {
        this.port = this.getSourcePortAt(e.getPoint());
        if (this.port != null) {
            return true;
        }
        return super.isForceMarqueeEvent(e);
    }

    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isRightMouseButton(e)) {
            if (this.port != null && !e.isConsumed()) {
                FreakPort fPort = (FreakPort)this.port.getCell();
                if (fPort.getPort() instanceof OutPort) {
                    this.start = this.graph.toScreen(this.port.getLocation(null));
                    this.firstPort = this.port;
                    e.consume();
                } else {
                    super.mousePressed(e);
                }
            } else {
                super.mousePressed(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.start != null && !e.isConsumed()) {
            PortView newPort;
            Graphics g = this.graph.getGraphics();
            this.paintConnector(Color.BLACK, this.graph.getBackground(), g);
            this.port = newPort = this.getTargetPortAt(e.getPoint());
            this.current = this.port != null ? this.graph.toScreen(this.port.getLocation(null)) : this.graph.snap(e.getPoint());
            this.paintConnector(this.graph.getBackground(), Color.black, g);
            e.consume();
        }
        super.mouseDragged(e);
    }

    public PortView getSourcePortAt(Point point) {
        Point tmp = this.graph.fromScreen(new Point(point));
        PortView port = this.graph.getPortViewAt(tmp.x, tmp.y);
        if (port == null) {
            return null;
        }
        FreakPort fPort = (FreakPort)port.getCell();
        if (!(fPort.getPort().getOperator() instanceof Finish) && fPort.getPort() instanceof OutPort) {
            return port;
        }
        return null;
    }

    protected PortView getTargetPortAt(Point point) {
        FreakPort fPort;
        Point tmp = this.graph.fromScreen(new Point(point));
        PortView port = this.graph.getPortViewAt(tmp.x, tmp.y);
        if (port != null && (fPort = (FreakPort)port.getCell()).getPort() instanceof InPort && !((FreakGraphModel)this.graph.getModel()).hasCircle((FreakPort)this.firstPort.getCell(), fPort)) {
            int i = fPort.getPort().getNumberOfPartners() - 1;
            while (i >= 0) {
                if (fPort.getPort().getPartner(i) == ((FreakPort)this.firstPort.getCell()).getPort()) {
                    return null;
                }
                --i;
            }
            if (!(fPort.getPort().getOperator() instanceof Start)) {
                return port;
            }
        }
        return null;
    }

    public void mouseReleased(MouseEvent e) {
        if (e != null && !e.isConsumed() && this.port != null && this.firstPort != null && this.firstPort != this.port) {
            FreakPort fPort = (FreakPort)this.port.getCell();
            if (this.port != null && fPort.getPort() instanceof InPort && !((FreakGraphModel)this.graph.getModel()).hasCircle((FreakPort)this.firstPort.getCell(), fPort)) {
                this.editor.connect((Port)this.firstPort.getCell(), (Port)this.port.getCell());
                e.consume();
            } else {
                this.graph.repaint();
            }
        } else {
            this.graph.repaint();
        }
        this.port = null;
        this.firstPort = null;
        this.current = null;
        this.start = null;
        super.mouseReleased(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (e != null && this.getSourcePortAt(e.getPoint()) != null && !e.isConsumed() && this.graph.isPortsVisible()) {
            this.graph.setCursor(new Cursor(12));
            e.consume();
        }
        super.mouseReleased(e);
    }

    protected void paintConnector(Color fg, Color bg, Graphics g) {
        g.setColor(fg);
        g.setXORMode(bg);
        if (this.firstPort != null && this.start != null && this.current != null) {
            g.drawLine(this.start.x, this.start.y, this.current.x, this.current.y);
        }
    }
}

