/*
 * Decompiled with CFR 0.152.
 */
package freak.core.modulesupport.inspector;

import freak.core.modulesupport.inspector.DoubleArrayRenderer;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;

public class DoubleArrayEditor
extends DefaultCellEditor {
    private JTextField textField = new JTextField("");
    private Double[] old;

    public DoubleArrayEditor() {
        super(new JTextField());
        this.editorComponent = this.textField;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.old = (Double[])value;
        this.textField.setText(DoubleArrayRenderer.doubleArrayToString(this.old));
        return this.textField;
    }

    public Object getCellEditorValue() {
        if (this.old.length == 0) {
            return this.old;
        }
        Double[] newValue = new Double[this.old.length];
        String text = this.textField.getText();
        if (text.charAt(0) != '(' || text.charAt(text.length() - 1) != ')') {
            return this.old;
        }
        text = text.substring(1, text.length() - 1);
        boolean last = false;
        int count = 0;
        while (!last) {
            if (text.indexOf(",") == -1) {
                last = true;
                try {
                    newValue[count] = new Double(text);
                    ++count;
                    continue;
                }
                catch (NumberFormatException e) {
                    return this.old;
                }
            }
            String s = text.substring(0, text.indexOf(","));
            text = text.substring(text.indexOf(",") + 1);
            try {
                newValue[count] = new Double(s);
                ++count;
            }
            catch (NumberFormatException e) {
                return this.old;
            }
        }
        if (count != this.old.length) {
            return this.old;
        }
        return newValue;
    }
}

