/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.initialization;

import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.Initialization;
import freak.core.graph.OperatorGraph;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.core.searchspace.SearchSpace;

public class RandomInitialization
extends Initialization
implements Configurable,
CompatibleWithDifferentSearchSpaces {
    private int size = 1;

    public RandomInitialization(OperatorGraph graph) {
        super(graph);
    }

    public IndividualList[] process(IndividualList[] origin) {
        IndividualList[] result = new IndividualList[]{new Population(this.graph.getSchedule(), this.size)};
        SearchSpace sp = this.graph.getSchedule().getGenotypeSearchSpace();
        int i = 0;
        while (i < this.size) {
            result[0].addIndividual(new Individual(this.graph.getSchedule(), sp.getRandomGenotype(), null));
            ++i;
        }
        return result;
    }

    public Integer getPropertySize() {
        return new Integer(this.size);
    }

    public void setPropertySize(Integer no) {
        if (no > 0) {
            this.size = no;
        }
    }

    public String getLongDescriptionForSize() {
        return "The number of individuals to be created.";
    }

    public String getName() {
        return "RandomInitialization";
    }

    public String getDescription() {
        return "Creates individuals uniform randomly distributed in the chosen search space.";
    }
}

