/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.utilities.graph;

import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.cappello3.UpperBound;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Matching;
import edu.ucsb.cs.jicos.applications.utilities.graph.Graph;
import edu.ucsb.cs.jicos.applications.utilities.graph.WeightedMatch;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;

public final class GraphEuclidean
implements Graph {
    private static final int VERTEX_DIAMETER = 6;
    private Vertex[] vertices;
    private int[][] distances;
    private int magnification;

    public GraphEuclidean(int n, int n2, int n3) {
        this.magnification = n3;
        Random random = new Random(n2);
        this.vertices = new Vertex[n];
        int n4 = 0;
        while (n4 < n) {
            this.vertices[n4] = new Vertex(random.nextFloat(), random.nextFloat());
            ++n4;
        }
        this.distances = new int[n][n];
        float f = n3;
        int n5 = 0;
        while (n5 < n) {
            int n6 = 0;
            while (n6 < n5) {
                int n7 = this.distance(n5, n6, f);
                this.distances[n6][n5] = n7;
                this.distances[n5][n6] = n7;
                ++n6;
            }
            ++n5;
        }
    }

    public int cost(int n, int n2) {
        return this.distances[n][n2];
    }

    public int[][] getCosts() {
        return this.distances;
    }

    public int[] getMinCostMaxMatch() {
        WeightedMatch weightedMatch = new WeightedMatch(this.distances);
        int[] nArray = weightedMatch.weightedMatch(true);
        return weightedMatch.getMatched(nArray);
    }

    public int[] getMaxCostMaxMatch() {
        WeightedMatch weightedMatch = new WeightedMatch(this.distances);
        int[] nArray = weightedMatch.weightedMatch(false);
        return weightedMatch.getMatched(nArray);
    }

    public int size() {
        return this.vertices.length;
    }

    public void drawMatching(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.red);
        WeightedMatch weightedMatch = new WeightedMatch(this.distances);
        int[] nArray = weightedMatch.weightedMatch(true);
        int n4 = 1;
        while (n4 <= this.vertices.length) {
            if (n4 < nArray[n4]) {
                int n5 = (int)(this.vertices[n4 - 1].getX() * (float)n3);
                int n6 = (int)(this.vertices[n4 - 1].getY() * (float)n3);
                int n7 = (int)(this.vertices[nArray[n4] - 1].getX() * (float)n3);
                int n8 = (int)(this.vertices[nArray[n4] - 1].getY() * (float)n3);
                graphics.drawLine(n + n5, n2 + n6, n + n7, n2 + n8);
            }
            ++n4;
        }
    }

    public void drawCappello3(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        UpperBound upperBound = new UpperBound(this.distances);
        int[] nArray = upperBound.getTour();
        int n8 = 0;
        int n9 = nArray[0];
        graphics.setColor(Color.red);
        int n10 = 1;
        while (n10 < nArray.length) {
            n7 = nArray[n10];
            System.out.print(" " + n7);
            n8 += this.distances[n9][n7];
            n6 = (int)(this.vertices[n9].getX() * (float)n3);
            n5 = (int)(this.vertices[n9].getY() * (float)n3);
            n4 = (int)(this.vertices[n7].getX() * (float)n3);
            int n11 = (int)(this.vertices[n7].getY() * (float)n3);
            graphics.drawLine(n + n6, n2 + n5, n + n4, n2 + n11);
            n9 = n7;
            ++n10;
        }
        n7 = (int)(this.vertices[n9].getX() * (float)n3);
        n6 = (int)(this.vertices[n9].getY() * (float)n3);
        n5 = (int)(this.vertices[nArray[0]].getX() * (float)n3);
        n4 = (int)(this.vertices[nArray[0]].getY() * (float)n3);
        graphics.drawLine(n + n7, n2 + n6, n + n5, n2 + n4);
    }

    public void drawTour(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        Matching matching = new Matching(this.distances);
        matching.setTour();
        int[] nArray = matching.getTour();
        int n8 = 0;
        int n9 = nArray[0];
        System.out.print(" Tour: \n   " + n9);
        graphics.setColor(Color.red);
        int n10 = 1;
        while (n10 < nArray.length) {
            n7 = nArray[n10];
            System.out.print(" " + n7);
            n8 += this.distances[n9][n7];
            n6 = (int)(this.vertices[n9].getX() * (float)n3);
            n5 = (int)(this.vertices[n9].getY() * (float)n3);
            n4 = (int)(this.vertices[n7].getX() * (float)n3);
            int n11 = (int)(this.vertices[n7].getY() * (float)n3);
            graphics.drawLine(n + n6, n2 + n5, n + n4, n2 + n11);
            n9 = n7;
            ++n10;
        }
        System.out.println(" ");
        n7 = (int)(this.vertices[n9].getX() * (float)n3);
        n6 = (int)(this.vertices[n9].getY() * (float)n3);
        n5 = (int)(this.vertices[nArray[0]].getX() * (float)n3);
        n4 = (int)(this.vertices[nArray[0]].getY() * (float)n3);
        graphics.drawLine(n + n7, n2 + n6, n + n5, n2 + n4);
    }

    public void drawVertices(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(Color.blue);
        int n4 = 0;
        while (n4 < this.vertices.length) {
            int n5 = (int)(this.vertices[n4].getX() * (float)n3);
            int n6 = (int)(this.vertices[n4].getY() * (float)n3);
            graphics.fillOval(n + n5 - 3, n2 + n6 - 3, 6, 6);
            graphics.drawString("" + n4, n + n5 - 2, n2 + n6 - 2);
            ++n4;
        }
    }

    private int distance(int n, int n2, float f) {
        float f2 = this.vertices[n].getX() - this.vertices[n2].getX();
        float f3 = this.vertices[n].getY() - this.vertices[n2].getY();
        return (int)(Math.sqrt(f2 * f2 + f3 * f3) * (double)f);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.distances.length) {
            stringBuffer.append("\n row ");
            stringBuffer.append(n);
            stringBuffer.append(": ");
            int n2 = 0;
            while (n2 < this.distances.length) {
                stringBuffer.append("\t");
                stringBuffer.append(this.distances[n][n2]);
                ++n2;
            }
            ++n;
        }
        stringBuffer.append("\n");
        return new String(stringBuffer);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = n = Integer.parseInt(stringArray[0]);
        int n3 = 500;
        GraphEuclidean graphEuclidean = new GraphEuclidean(n, n2, n3);
    }

    private class Vertex {
        private float x;
        private float y;

        Vertex(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        float getX() {
            return this.x;
        }

        float getY() {
            return this.y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }
}

