/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.IndividualList;

public class CurrentElitists
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public CurrentElitists(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "Current Elitists";
    }

    public String getDescription() {
        return "Displays the fittest individuals among the observed individuals.";
    }

    public Class getOutputDataType() {
        return IndividualList.class;
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList().getAllIndividualsWithRank(1);
        this.updateViews(individualList);
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

