/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.bitstring;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractStaticSingleObjectiveFitnessFunction;
import freak.core.population.Genotype;
import freak.module.searchspace.BitString;
import freak.module.searchspace.BitStringGenotype;
import java.util.BitSet;

public class PathWithTrap
extends AbstractStaticSingleObjectiveFitnessFunction {
    public PathWithTrap(Schedule schedule) {
        super(schedule);
    }

    private boolean trapped(BitSet bs) {
        int n = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int onemax = bs.cardinality();
        if (onemax < n / 4 || onemax > 3 * n / 4) {
            return false;
        }
        int onesInFirstPart = 0;
        boolean foundPoint = false;
        int i = 0;
        while (i < n) {
            int zeroesInFirstPart = i - onesInFirstPart;
            int differenceInSecondPart = onemax - onesInFirstPart;
            int difference = zeroesInFirstPart + differenceInSecondPart;
            if (difference <= n / 6 && difference >= n / 12) {
                foundPoint = true;
            }
            if (difference < n / 24) {
                return false;
            }
            if (bs.get(i)) {
                ++onesInFirstPart;
            }
            ++i;
        }
        return foundPoint;
    }

    protected double evaluate(Genotype genotype) {
        BitSet bs = ((BitStringGenotype)genotype).getBitSet();
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        int cardinality = bs.cardinality();
        if (cardinality == dimension) {
            return 3 * dimension;
        }
        boolean onPath = true;
        boolean firstPart = true;
        int leadingOnes = 0;
        int i = 0;
        while (i < dimension) {
            boolean bit = bs.get(i);
            if (!firstPart && bit) {
                onPath = false;
                break;
            }
            if (!bit) {
                firstPart = false;
            } else {
                ++leadingOnes;
            }
            ++i;
        }
        if (onPath) {
            return dimension + leadingOnes;
        }
        if (this.trapped(bs)) {
            return 2 * dimension;
        }
        return dimension - bs.cardinality();
    }

    public String getName() {
        return "Path With Trap";
    }

    public String getDescription() {
        return "A function to demonstrate that the dynamic (1+1)EA can get trapped. The individuals have to climb a path to the global optimum. Near the path is a line of traps, so increasing the mutation probability causes the individuals to leave the path and jump into the traps.";
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        return 3 * ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return 0.0;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.getOptimalFitnessValue();
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        int dimension = ((BitString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        BitSet bs = new BitSet(dimension);
        bs.set(0, dimension);
        return new BitStringGenotype(bs, dimension);
    }
}

