/*
 * Decompiled with CFR 0.152.
 */
package freak.rinterface.model;

import freak.core.control.Batch;
import freak.core.control.BatchList;
import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.graph.FreakGraphModel;
import freak.core.graph.Initialization;
import freak.core.mapper.Mapper;
import freak.core.modulesupport.AbstractBasicModule;
import freak.core.modulesupport.AbstractModule;
import freak.core.modulesupport.ModuleInfo;
import freak.core.modulesupport.OperatorGraphCollector;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.Observer;
import freak.core.observer.ObserverManager;
import freak.core.observer.ObserverViewMismatchException;
import freak.core.populationmanager.PopulationManager;
import freak.core.searchspace.SearchSpace;
import freak.core.stoppingcriterion.StoppingCriterion;
import freak.core.util.GraphViz;
import freak.gui.graph.OperatorGraphFile;
import freak.gui.scheduleeditor.ScheduleDependencyChecker;
import freak.module.fitness.booleanfunction.GenericPareto;
import freak.module.fitness.pointset.LtSOptimization;
import freak.module.mapper.pointset.BitStringMapper;
import freak.module.observer.ResultObserver;
import freak.module.operator.initialization.LTSInitialization;
import freak.module.operator.initialization.RandomInitialization;
import freak.module.populationmanager.DefaultPopulationManager;
import freak.module.postprocessor.booleanfunction.Count;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.PointSet;
import freak.module.stoppingcriterion.GenerationCount;
import freak.module.view.RReturn;
import freak.rinterface.model.RDoubleMatrix;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;

public class ScheduleConfigurator {
    static Schedule currentSchedule;
    static boolean editingFinished;

    static {
        editingFinished = false;
    }

    public static Schedule getCurrentSchedule() {
        return currentSchedule;
    }

    public static void setCurrentSchedule(Schedule sched) {
        currentSchedule = sched;
        editingFinished = true;
    }

    private static void updateBatchForSchedule(Schedule schedule, int runs) {
        Batch batch = schedule.createBatchFromCurrentConfigurations();
        batch.setRuns(runs);
        BatchList batchList = schedule.getBatchList();
        batchList.clear();
        batchList.add(batch.copy(), true);
        schedule.setDefaultBatch(batch);
    }

    public static void setDiscriminationR(int runs, int generations) {
        ScheduleConfigurator.setDiscrimination("ignored", runs, generations, "ignored", "");
    }

    public static void setDiscrimination(String path, int runs, int generations, String testDataPath, String saveTo) {
        AbstractModule m;
        ScheduleConfigurator.createSchedule(path, runs, generations);
        try {
            currentSchedule.setFitnessFunction(null);
            m = new GenericPareto(currentSchedule);
            ((GenericPareto)m).setParetoObjective(new int[]{1, 2, 4});
            ((GenericPareto)m).setPropertySubsets(new Integer(1));
            ((GenericPareto)m).setPropertySizePruning(new Integer(12));
            m.testSchedule(currentSchedule);
            m.initialize();
            m.createEvents();
            currentSchedule.setFitnessFunction((FitnessFunction)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ObserverManager om = currentSchedule.getObserverManager();
        m = new ResultObserver(currentSchedule);
        ((ResultObserver)m).setPropertyTestData(testDataPath);
        if (saveTo.trim().equals("")) {
            RReturn rReturn = new RReturn(currentSchedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        } else {
            freak.module.view.FileWriter output = new freak.module.view.FileWriter(currentSchedule);
            output.setPropertyFile(new File(saveTo));
            try {
                ((Observer)((Object)m)).addView(output);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        }
        m.initialize();
        m.createEvents();
        om.addObserver((Observer)((Object)m));
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, runs);
    }

    public static void setInteractionR(int runs, int generations, String graphFile, int occurences, double ratio) {
        ScheduleConfigurator.setInteraction("ignored", runs, generations, graphFile, occurences, ratio, "");
    }

    public static void setInteraction(String path, int runs, int generations, String graphFile, int occurences, double ratio, String saveTo) {
        AbstractModule m;
        ScheduleConfigurator.createSchedule(path, runs, generations);
        try {
            currentSchedule.setFitnessFunction(null);
            m = new GenericPareto(currentSchedule);
            ((GenericPareto)m).setParetoObjective(new int[]{3, 2, 4});
            ((GenericPareto)m).setPropertySubsets(new Integer(1));
            ((GenericPareto)m).setPropertySizePruning(new Integer(12));
            m.testSchedule(currentSchedule);
            m.initialize();
            m.createEvents();
            currentSchedule.setFitnessFunction((FitnessFunction)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ObserverManager om = currentSchedule.getObserverManager();
        m = new ResultObserver(currentSchedule);
        ((ResultObserver)m).setPropertyTestData("");
        if (saveTo.trim().equals("")) {
            RReturn rReturn = new RReturn(currentSchedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        } else {
            freak.module.view.FileWriter output = new freak.module.view.FileWriter(currentSchedule);
            output.setPropertyFile(new File(saveTo));
            try {
                ((Observer)((Object)m)).addView(output);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
        }
        ((ResultObserver)m).setPostprocessor(-1);
        ((ResultObserver)m).setSelectPostprocessorFromGui(false);
        Count postprocessor = new Count(currentSchedule);
        Count.fileName = graphFile;
        Count.minCount = occurences;
        Count.minPercent = ratio;
        ((ResultObserver)m).setSelectedProcessor(postprocessor);
        m.initialize();
        m.createEvents();
        om.addObserver((Observer)((Object)m));
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, runs);
    }

    public static void setGenerationCount(int gencount) {
        try {
            GenerationCount generationCount = new GenerationCount(currentSchedule);
            generationCount.setPropertyCount(new Integer(gencount));
            generationCount.testSchedule(currentSchedule);
            generationCount.initialize();
            generationCount.createEvents();
            StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
            currentSchedule.setStoppingCriteria(stoppingCriteria);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        System.out.println("GenerationCount has been set from R");
    }

    public static void setOperatorGraph(String ogLocation) {
        File f = new File(ogLocation);
        try {
            OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(f));
            FreakGraphModel model = ogFile.generateGraph(currentSchedule);
            currentSchedule.setGraphModel(model);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        System.out.println("OperatorGraph has been set from R");
    }

    public static void printOperatorGraph() {
        GraphViz gv = new GraphViz();
        FreakGraphModel model = currentSchedule.getGraphModel();
        String dotSource = model.getOperatorGraph().toDotGraph();
        File graphDot = new File("operatorgraph.dot");
        try {
            FileWriter fout = new FileWriter(graphDot);
            fout.write(dotSource);
            fout.close();
        }
        catch (Exception e) {
            System.err.println("Error: I/O error while writing the dot source");
        }
        File graphGif = new File("operatorgraph.gif");
        GraphViz.DOT = "C:\\Program Files\\graphviz\\Graphviz\\bin\\dot";
        try {
            gv.writeGraphToFile(gv.getGraph(dotSource), graphGif);
        }
        catch (Exception e1) {
            GraphViz.DOT = "/usr/local/graphviz-2.12/bin/dot";
            try {
                gv.writeGraphToFile(gv.getGraph(dotSource), graphGif);
            }
            catch (Exception e2) {
                System.out.println("DOT not found");
            }
        }
    }

    public static Schedule getLTSSchedule(RDoubleMatrix data, int h, boolean adjust, int runs, int generationCountStop) {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            AbstractBasicModule m = new PointSet(schedule);
            int noOfPoints = data.getDim()[0];
            int dimension = data.getDim()[1];
            PointSet.Point[] points = new PointSet.Point[noOfPoints];
            int i = 0;
            while (i < noOfPoints) {
                points[i] = new PointSet.Point(dimension);
                int j = 0;
                while (j < dimension) {
                    points[i].setK(j, data.getValues()[i + j * noOfPoints]);
                    ++j;
                }
                ++i;
            }
            ((PointSet)m).setPoints(points);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new LtSOptimization(schedule);
            ((LtSOptimization)m).setPropertyH(new Integer(h));
            ((LtSOptimization)m).setPropertyAdjust(adjust);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            m = new BitStringMapper(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setMapper((Mapper)((Object)m));
            if (generationCountStop > 0) {
                GenerationCount generationCount = new GenerationCount(schedule);
                generationCount.setPropertyCount(new Integer(generationCountStop));
                generationCount.testSchedule(schedule);
                generationCount.initialize();
                generationCount.createEvents();
                StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
                schedule.setStoppingCriteria(stoppingCriteria);
            }
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            OperatorGraphCollector collector = new OperatorGraphCollector(schedule);
            ModuleInfo[] graphs = collector.getPredefinedGraphs("LTSGraph.fop");
            if (graphs != null) {
                try {
                    OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(new File(graphs[0].getClassName())));
                    FreakGraphModel model = ogFile.generateGraph(schedule);
                    model.getOperatorGraph().setName(graphs[0].getName());
                    schedule.setGraphModel(model);
                }
                catch (Exception exc) {
                    System.out.println("Error loading graph " + graphs[0].getClassName());
                    exc.printStackTrace();
                }
            }
            m = new LTSInitialization(schedule.getOperatorGraph());
            ((LTSInitialization)m).setPropertyNoOfBitsSetted(dimension);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
            ObserverManager om = schedule.getObserverManager();
            m = new ResultObserver(schedule);
            RReturn rReturn = new RReturn(schedule);
            try {
                ((Observer)((Object)m)).addView(rReturn);
            }
            catch (ObserverViewMismatchException e) {
                e.printStackTrace();
            }
            m.initialize();
            m.createEvents();
            om.addObserver((Observer)((Object)m));
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ScheduleConfigurator.updateBatchForSchedule(schedule, runs);
        schedule.modulesEdited();
        return schedule;
    }

    public static Schedule createSchedule(String path, int runs, int generationCountStop) {
        Schedule schedule = new Schedule();
        ScheduleDependencyChecker scheduleDependencyChecker = new ScheduleDependencyChecker(null);
        scheduleDependencyChecker.setSchedule(schedule);
        try {
            AbstractBasicModule m = new BooleanFunction(schedule);
            ((BooleanFunction)m).setPropertyInputPath(path);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPhenotypeSearchSpace((SearchSpace)((Object)m));
            m = new GenericPareto(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setFitnessFunction((FitnessFunction)((Object)m));
            if (generationCountStop > 0) {
                GenerationCount generationCount = new GenerationCount(schedule);
                generationCount.setPropertyCount(new Integer(generationCountStop));
                generationCount.testSchedule(schedule);
                generationCount.initialize();
                generationCount.createEvents();
                StoppingCriterion[] stoppingCriteria = new StoppingCriterion[]{generationCount};
                schedule.setStoppingCriteria(stoppingCriteria);
            }
            m = new DefaultPopulationManager(schedule);
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            schedule.setPopulationManager((PopulationManager)((Object)m));
            OperatorGraphCollector collector = new OperatorGraphCollector(schedule);
            ModuleInfo[] graphs = collector.getPredefinedGraphs("GPASGraph.fop");
            if (graphs != null) {
                try {
                    OperatorGraphFile ogFile = OperatorGraphFile.read(new FileInputStream(new File(graphs[0].getClassName())));
                    FreakGraphModel model = ogFile.generateGraph(schedule);
                    model.getOperatorGraph().setName(graphs[0].getName());
                    schedule.setGraphModel(model);
                }
                catch (Exception exc) {
                    System.out.println("Error loading graph " + graphs[0].getClassName());
                    exc.printStackTrace();
                }
            }
            m = new RandomInitialization(schedule.getOperatorGraph());
            m.testSchedule(schedule);
            m.initialize();
            m.createEvents();
            ((Initialization)m).hideNameProperty();
            schedule.setInitialization((Initialization)m);
        }
        catch (UnsupportedEnvironmentException e) {
            throw new RuntimeException("Something is wrong with the default Schedule.", e);
        }
        ScheduleConfigurator.updateBatchForSchedule(schedule, runs);
        schedule.modulesEdited();
        currentSchedule = schedule;
        return schedule;
    }

    public static Schedule createDefaultSchedule() {
        currentSchedule = ScheduleConfigurator.createSchedule("./data/snap.csv", 1, 0);
        ObserverManager om = currentSchedule.getObserverManager();
        ResultObserver m = new ResultObserver(currentSchedule);
        RReturn rReturn = new RReturn(currentSchedule);
        try {
            ((Observer)m).addView(rReturn);
        }
        catch (ObserverViewMismatchException e) {
            e.printStackTrace();
        }
        m.initialize();
        m.createEvents();
        om.addObserver(m);
        ScheduleConfigurator.updateBatchForSchedule(currentSchedule, 1);
        return currentSchedule;
    }

    public static boolean isEditingFinished() {
        return editingFinished;
    }

    public static void setEditingFinished(boolean editingFinished) {
        ScheduleConfigurator.editingFinished = editingFinished;
    }
}

