/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.observer.AbstractObserver;

public class AverageRunTime
extends AbstractObserver
implements BatchEventListener,
RunEventListener {
    private double averageRunTime = 0.0;
    private double numberOfObservedRuns = 0.0;

    public AverageRunTime(Schedule schedule) {
        super(schedule);
        this.setMeasure(3);
    }

    public Class getOutputDataType() {
        return Double.class;
    }

    public String getName() {
        return "Average Run Time";
    }

    public String getDescription() {
        return "Computes the average run time within all runs in the current batch.";
    }

    public void runFinalize(RunEvent evt) {
        int newValue = this.getSchedule().getCurrentGeneration();
        this.averageRunTime = (this.numberOfObservedRuns * this.averageRunTime + (double)newValue) / (this.numberOfObservedRuns + 1.0);
        this.numberOfObservedRuns += 1.0;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void batchFinished(BatchEvent evt) {
        this.updateViews(new Double(this.averageRunTime));
        this.numberOfObservedRuns = 0.0;
    }
}

