% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rfpredinterval.R
\name{plot.rfpredinterval}
\alias{plot.rfpredinterval}
\title{Plot constructed prediction intervals for \code{('rfpredinterval', 'piall')} objects}
\usage{
\method{plot}{rfpredinterval}(x, test_id = 1, sort = TRUE, show_response = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{('rfpredinterval', 'piall')}.}

\item{test_id}{Integer value specifying the test observation to be plotted.
The default is 1.}

\item{sort}{Should the prediction intervals be sorted according to their
lengths in the plot? The default is \code{TRUE}.}

\item{show_response}{Should the true response value of the test observation
(if available) be displayed in the plot?}

\item{...}{Optional arguments to be passed to other methods.}
}
\value{
Invisibly, the prediction intervals and point predictions that were
plotted for the test observation.
}
\description{
Plots the 16 constructed PIs obtained with \code{piall()} for a test
observation. For each method, the red point presents the point prediction and
blue line shows the constructed prediction interval for the test
observation. If the true response of the test observation is known, it is
demonstrated with a dashed vertical line. Note that we may have multiple
prediction intervals with the HDR PI method.
}
\examples{
\donttest{
## load example data
data(BostonHousing, package = "RFpredInterval")
set.seed(2345)

## define train/test split
testindex <- 1
trainindex <- sample(2:nrow(BostonHousing), size = 50, replace = FALSE)
traindata <- BostonHousing[trainindex, ]
testdata <- BostonHousing[testindex, ]

## build 95\% PIs with all 16 methods for the first observation in testdata
out <- piall(formula = medv ~ ., traindata = traindata,
             testdata = testdata, num.trees = 50)

## plot the constructed PIs for test_id = 1 with all methods
plot(out, test_id = 1)
}


}
\seealso{
\code{\link{piall}}
}
