% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RFTuning.R
\name{tuneNTREE}
\alias{tuneNTREE}
\title{Tuning of the ntree parameter (i.e. the number of trees) for a Random Forest model}
\usage{
tuneNTREE(data, mtry, iterations, minNTREE = 500, pace = 100,
  seq_length = 5)
}
\arguments{
\item{data}{the n x p dataframe used to build the Random Forest models. The first two columns must represent respectively
the sample names and the class labels associated to each sample}

\item{mtry}{the chosen mtry value}

\item{iterations}{the number of Random Forest models to be built for each value of ntree}

\item{minNTREE}{the minimum number of trees of each random forest model.}

\item{pace}{the pace between each value of ntree to be tested}

\item{seq_length}{the number of ntree values to be tested}
}
\value{
a n x p matrix in which n is the number of models considered and p is the number of ntree values tested.
Each column represents the oob errors resulting from each model and corresponding to the different ntree values
}
\description{
This function tries to find the 'optimal' value for the parameter ntree which indicates 
the number of trees used to grow the ensemble of trees. To do that it will build several random forest models with a different 
number of trees for the mtry value considered. The number of models built for each ntree value will be equal to
the parameter iteration. The oob errors of each random forest model, computed 
for each ntree value will be arranged in a matrix.
}
\examples{
## data(cachexiaData)
## res <- tuneNTREE(cachexiaData, 8, iterations = 50, minNTREE = 600, pace = 100, seq_length = 10)
}
\author{
Piergiorgio Palla
}

