% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FPM.R
\name{FPM}
\alias{FPM}
\title{Floating Percentile Model}
\usage{
FPM(
  data,
  paramList,
  paramFixed = NULL,
  paramOverride = FALSE,
  increment = 10,
  precision = 0.1,
  FN_crit = 0.2,
  seed = 1,
  lockInfo = FALSE,
  ...
)
}
\arguments{
\item{data}{data.frame containing, at a minimum, chemical concentrations as columns and a logical \code{Hit} column classifying toxicity}

\item{paramList}{character vector of column names of chemical concentration variables in \code{data}}

\item{paramFixed}{character vector of column names of chemical concentration variables to retain, bypassing testing for specific chemicals (default = \code{NULL}). See Details.}

\item{paramOverride}{logical; whether to retain every chemical variable in \code{paramList} (default = \code{FALSE}). See Details.}

\item{increment}{numeric value greater than 1; number of increments to evaluate (default = \code{10}). See Details.}

\item{precision}{numeric value between 0 and 1 (default = \code{0.1})}

\item{FN_crit}{numeric vector of values between 0 and 1 indicating false negative threshold(s) for benchmark selection (default = \code{0.2})}

\item{seed}{random seed to set for reproducible results; only for handling edge cases of ranking ties (default = \code{1})}

\item{lockInfo}{logical; whether to return the reason for and order in which benchmarks were "locked" within the model algorithm (default = \code{FALSE}). See Details.}

\item{...}{additional argument passed to \code{chemSigSelect} and \code{chemSig}}
}
\value{
list of 2 or 4 objects (depending on \code{lockInfo}):
\enumerate{
\item Benchmarks and toxicity classification error statistics;
\item order in which benchmarks were locked in place;
\item reason for benchmarks being locked in place; and
\item \code{chemDensity} statistic
}
}
\description{
Generate sediment quality benchmarks using the floating percentile model algorithm
}
\details{
\code{FPM} is the main function provided in 'RFPM', which was developed firstly as a redevelopment of the Washington Department of Ecology's Excel-based
floating percentile model tool (Avocet 2003; Ecology 2011), and secondly as a means to evaluate uncertainties and sensitivities associated with the model. \code{FPM} generates
sediment quality benchmarks for chemicals with significantly higher concentrations among \code{Hit} samples (meaning they were determined to be categorically toxic).

\code{FPM} is an algorithmic approach to setting sediment quality benchmarks using sediment chemistry data and toxicity test results.
Toxicity is treated as a binary classification - either a \code{Hit == TRUE} or \code{Hit == FALSE} (meaning toxic or non-toxic) by some user-defined definition.
The most important input to \code{FPM} apart from the empirical data is \code{FN_crit}, which determines an upper limit for false negative errors associated with floating percentile model benchmarks.
The default \code{FN_crit} recommended by the Department of Ecology is \code{0.2}; though intended to be protective, the value of \code{0.2} is arbitrary. We recommend
that the user run the \code{optimFPM} and/or \code{cvFPM} functions to find the \code{FN_crit} value(s) that optimize benchmark performance within an acceptable error range for the site.
\code{optimFPM} can also help users optimize the \code{alpha} parameter (see \code{?chemSig}), which is also somewhat arbitrarily set at a conventional default of \code{0.05}.

There are two arguments that have defaults in \code{FPM} that the user may desire to change in certain circumstances, but that we
generally recommend not changing without good reason. These are \code{paramFixed} and \code{paramOverride}, which override the chemical
selection process, resulting in potentially non-toxic chemicals being assigned benchmarks.
The \code{paramFixed} argument, which only forces named chemicals into the model algorithm, is looser than \code{paramOverride}, which forces all chemicals in paramList into the model algorithm.
See \code{?chemSig} for more information regarding default parameters used within \code{FPM}.
Even if chemical names are supplied to \code{paramFixed}, \code{FPM} will still use hypothesis testing methods to consider all other chemicals for inclusion.

\code{increment} determines (inversely) how large or small values should be that are added to percentile values in the model algorithm.
A larger \code{increment} results in smaller incremental additions and vice-versa. The WA Department of Ecology recommends a default of
\code{increment = 10}. This is a reasonable value, and we recommend not decreasing \code{increment} below \code{10}.
Increasing \code{increment} will increase computation time, and may or may not result in more accurate benchmarks. So, we recommend not
increasing \code{increment} much higher than \code{10}.

\code{precision} determines how many iterative loops will be attempted within the model algorithm when trying to increase each benchmark. If increasing the
benchmark would increase the false negative rate above \code{FN_crit}, the benchmark would then be decreased, the increment size is divided by \code{increment}, and
then the smaller incremental addition is used to increase the benchmark. This process repeats for a fixed number of iterations, which is related to \code{precision}.
If the benchmark cannot be increased after the fixed number of iterations, the benchmark is locked in place.
The default value for \code{precision} is \code{0.1}, but the value could be lower, if desired. Lowering the value will increase computation time and may or may not
result in more accurate benchmarks. In general, we recommend reducing \code{precision} rather than increasing \code{increment} in order to potentially enhance the
precision of benchmark calculations.

The \code{lockInfo} argument allows the user to export information about what caused the model algorithm to lock for each
chemical. Output options are: \code{"FN"} for exceeding the false negative limit (i.e., \code{FN_crit}), \code{"FP"} if the number of false positives was reduced to zero,
\code{"Max"} if the empirical maximum concentration was exceeded, or \code{Mix} if more than one of the first three options occurred.

The following classification statistics are reported alongside the generated benchmarks:
\code{TP}, \code{FN}, \code{TN}, and \code{FP} - the numbers of true positive, false negative, true negative, and false positive predictions
\code{pFN} and \code{pFP} - proportions of false predictions (false No-hit and false Hit, respectively)
\code{HR} - hit rate or sensitivity; the probability of detecting a Hit
\code{NR} - negative rate or specificity; the probability of detecting a No-hit
\code{PHR} - positive predictive value or precision; how often were Hit predictions correct?
\code{PNR} - negative predictive value; how often were No-hit predictions correct?
\code{FHR} - false positive predictive value; how often were Hit predictions incorrect?
\code{FNR} - false negative predictive value; how often were No-hit predictions incorrect?
\code{OR} - overall reliability; the probability of making a correct prediction (Hit or No-hit)

The second output of \code{FPM} is a metric called \code{chemDensity}. This is a measure of how much
the percentile "floated" in the algorithm from the starting position up to the chemical's value at which it was locked in place.
Values of \code{chemDensity} closer to 1 floated less and vice-versa. By floating less, this indicates that
even small changes in the chemical concentration resulted in one of the acceptance criteria failing (as discussed above with regard to \code{lockInfo}). When comparing
the \code{chemDensity} among chemicals, those with lower values might be viewed as having less of an influence on toxicity predictions
and vice-versa. For those interested in understanding the relative importance of chemicals among benchmarks, we recommend using \code{chemVI} and considering the \code{MADP} and \code{dOR} outputs.
}
\examples{
paramList = c("Cd", "Cu", "Fe", "Mn", "Ni", "Pb", "Zn")
FPM(data = h.tristate, paramList = paramList, ExcelMode = TRUE, warn = FALSE)
FPM(data = h.tristate, paramList = paramList, FN_crit = c(0.1, 0.2, 0.3))
}
\references{
Avocet. 2003. Development of freshwater sediment quality values for use in Washington State. Phase II report: Development and recommendation of SQVs for freshwater sediments in Washington State. Publication No. 03-09-088. Prepared for Washington Department of Ecology. Avocet Consulting, Kenmore, WA.
Ecology. 2011. Development of benthic SQVs for freshwater sediments in Washington, Oregon, and Idaho. Publication no. 11-09-054. Toxics Cleanup Program, Washington State Department of Ecology, Olympia, WA.
}
\seealso{
optimFPM, cvFPM, chemSig, chemSigSelect, chemVI
}
