/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.genome;

import javalain.algorithmegenetique.Chromosome;
import javalain.algorithmegenetique.DomaineReel;
import javalain.algorithmegenetique.chromosome.ChromoFixeReel;
import javalain.algorithmegenetique.gene.ReelDouble;
import javalain.algorithmegenetique.genome.GenomeFct;
import javalain.ea.Solution;
import javalain.ea.operator.Crossover;
import javalain.ea.operator.Mutator;

public final class ChromosomeFct
extends ChromoFixeReel {
    public static final int SBX = 256;
    private mode_mutation modeMutation;
    private GenomeFct genome;

    public ChromosomeFct(int pTaille, int pModeCroisement, mode_mutation pModeMutation, GenomeFct pGenome) {
        super(pTaille, pModeCroisement);
        this.modeMutation = pModeMutation;
        this.genome = pGenome;
    }

    @Override
    public Chromosome[] croisement(Chromosome parent) {
        if (this.modeCroisement == 256) {
            Solution p1 = new Solution(this.toArray());
            Solution p2 = new Solution(((ChromoFixeReel)parent).toArray());
            Solution[] enfants = Crossover.SBX(1.0, p1, p2, this.genome.getFct(), 20.0);
            ChromosomeFct ch1 = new ChromosomeFct(this.size(), this.modeCroisement, this.modeMutation, this.genome);
            ChromosomeFct ch2 = new ChromosomeFct(this.size(), this.modeCroisement, this.modeMutation, this.genome);
            for (int i = 0; i < enfants[0].getNbVariable(); ++i) {
                ReelDouble rd = new ReelDouble(new DomaineReel(this.genome.getFct().getLowerLimit(i), this.genome.getFct().getUpperLimit(i)));
                rd.set(enfants[0].getVariable(i));
                ch1.addGene(rd);
                rd = new ReelDouble(new DomaineReel(this.genome.getFct().getLowerLimit(i), this.genome.getFct().getUpperLimit(i)));
                rd.set(enfants[1].getVariable(i));
                ch2.addGene(rd);
            }
            Chromosome[] ch = new ChromosomeFct[]{ch1, ch2};
            return ch;
        }
        return super.croisement(parent);
    }

    @Override
    public boolean mutation(double Pm) {
        if (this.modeMutation == mode_mutation.MUT_POLYNOMIALE) {
            for (int i = 0; i < this.size(); ++i) {
                ReelDouble rd = (ReelDouble)this.getGene(i);
                rd.set(Mutator.mutationPolynomiale(Pm, rd.get(), rd.getIntervalle().getMin(), rd.getIntervalle().getMax(), 20.0));
            }
            return true;
        }
        return super.mutation(Pm);
    }

    public static enum mode_mutation {
        MUT_GENE,
        MUT_POLYNOMIALE;

    }
}

