% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotConvergence}
\alias{plotConvergence}
\title{Log-likelihood convergence}
\usage{
plotConvergence(fit, ...)
}
\arguments{
\item{fit}{fit object of class remix, from \code{\link{remix}} or a certain build from \code{\link{cv.remix}} output.}

\item{...}{opptional additional arguments.}
}
\value{
Log-Likelihood values throughout the algorithm iteration.
}
\description{
Log-likelihood convergence
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)
lambda = 1440

res = remix(project = project,
            dynFUN = dynFUN,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            eps2=1,
            lambda=lambda)

plotConvergence(res)

trueValue = read.csv(paste0(dirname(project),"/demoSMLX/Simulation/populationParameters.txt"))#'

plotSAEM(res,paramToPlot = c("delta_S_pop","phi_S_pop","delta_AB_pop"),trueValue=trueValue)
}
}
\seealso{
\code{\link{remix}}, \code{\link{cv.remix}}.
}
