% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_tibble.R
\name{extract_tibbles}
\alias{extract_tibbles}
\title{Extract data tibbles from a REDCapTidieR supertibble into a list}
\usage{
extract_tibbles(supertbl, tbls = everything())
}
\arguments{
\item{supertbl}{A supertibble generated by \code{read_redcap()}. Required.}

\item{tbls}{A vector of \code{form_name}s or a tidyselect helper. Default is
\code{dplyr::everything()}.}
}
\value{
A named list of \code{tibble}s
}
\description{
Take a supertibble generated with \code{read_redcap()}
and return a named list of data tibbles.
}
\details{
This function makes it easy to extract a multiple instrument's data from a
REDCapTidieR supertibble into a named list. Specifying instruments using
tidyselect helper functions such as \code{dplyr::starts_with()}
or \code{dplyr::ends_with()} is supported.
}
\examples{
# Mock up a supertibble
sample_data <- tibble::tribble(
  ~redcap_form_name,    ~redcap_data, ~structure,
  "super_hero_powers",  list(),       "repeating",
  "heroes_information", list(),       "nonrepeating"
)

# Extract all data tibbles
extract_tibbles(sample_data)

# Only extract data tibbles starting with "heroes"
extract_tibbles(sample_data, starts_with("heroes"))

}
