% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sanitize-token.R
\name{sanitize_token}
\alias{sanitize_token}
\title{Validate and sanitize the user's REDCap token}
\usage{
sanitize_token(token)
}
\arguments{
\item{token}{The REDCap token. Required.}
}
\value{
The token, without a terminal newline character.
}
\description{
Verifies the token is nonmissing and conforms to the legal pattern of a 32-character hexadecimal value.
Trailing line endings are removed.
}
\note{
Contact your institution's REDCap administrator for more information about your project-specific token.
}
\examples{
secret_token_1 <- "12345678901234567890123456ABCDEF"
secret_token_2 <- "12345678901234567890123456ABCDEF\\n"
REDCapR::sanitize_token(secret_token_1)
REDCapR::sanitize_token(secret_token_2)
}
\author{
Hao Zhu, Benjamin Nutter, Will Beasley
}
