% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Weibullmix.R
\name{Weibullmix}
\alias{Weibullmix}
\title{NPMLE for Weibull Mixtures}
\usage{
Weibullmix(
  x,
  v = 300,
  u = 300,
  alpha,
  lambda = 1,
  event = NULL,
  hist = FALSE,
  weights = NULL,
  ...
)
}
\arguments{
\item{x}{Survival times}

\item{v}{Grid values for mixing distribution}

\item{u}{Grid values for histogram bins, if needed}

\item{alpha}{Shape parameter for Weibull distribution}

\item{lambda}{Scale parameter for Weibull Distribution; must either have length 1, or length
equal to \code{length(x)} the latter case accommodates the possibility of a linear predictor}

\item{event}{censoring indicator, 1 if actual event time, 0 if censored}

\item{hist}{If TRUE aggregate to histogram counts}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components 
	\item{x}{points of evaluation on the domain of the density} 
	\item{y}{estimated function values at the points x of the mixing density} 
	\item{logLik}{Log likelihood value at the proposed solution} 
	\item{dy}{Bayes Rule estimates of mixing parameter} 
	\item{status}{exit code from the optimizer}
}
\description{
Kiefer-Wolfowitz NPMLE for Weibull Mixtures of scale parameter
}
\details{
Kiefer Wolfowitz NPMLE density estimation for Weibull scale mixtures. The
histogram option is intended for relatively large problems, say n > 1000,
where reducing the sample size dimension is desirable. By default the grid
for the binning is equally spaced on the support of the data.  Parameterization:
f(t|alpha, lambda) = alpha * exp(v) * (lambda * t )^(alpha-1) * 
exp(-(lambda * t)^alpha * exp(v)); shape = alpha; scale = lambda^(-1) * (exp(v))^(-1/alpha)
This version purports to handle right censoring.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. Volume 27, Number 4 (1956), 887-906.

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\seealso{
\code{Gompertzmix}
}
\author{
Roger Koenker and Jiaying Gu
}
\keyword{nonparametric}
