% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-import.R
\name{read.rdsat}
\alias{read.rdsat}
\title{Import data from the 'RDSAT' format as an \code{rds.data.frame}}
\usage{
read.rdsat(file, delim = c("<auto>", "\\t", " ", ","), N = NULL)
}
\arguments{
\item{file}{the name of the file which the data are to be read from.
If it
does not contain an _absolute_ path, the file name is
_relative_ to the current working directory, 'getwd()'.
Tilde-expansion is performed where supported.  As from R
2.10.0 this can be a compressed file (see 'file')}

\item{delim}{The seperator defining columns. <auto> will guess the
delimitor based on the file.}

\item{N}{The population size (Optional).}
}
\description{
This function imports RDSAT data files as \code{rds.data.frame} objects.
}
\examples{
fn <- paste0(path.package("RDS"),"/extdata/nyjazz.rdsat")
rd <- read.rdsat(fn)
plot(rd)
}

