#' @title Campaign Report
#' 
#' @description This function generates the campaign report statement and schedules the report. The API returns a job ID, which later will be used to receive the data from the API.
#' 
#' @param authToken Authentication token generated by \code{\link{doCriteoAuth}}
#' @param appToken Application Token
#' @param campaigns Vector of campaign IDs. Example: campaigns = c('12345', '01235', '98765')
#' @param metrics Vector of metrics. Example: metrics = c('clicks','impressions','cost','sales')
#'                available metrics: clicks, impressions, ctr, revcpc, ecpm, cost, sales, convRate, orderValue, salesPostView, convRatePostView, orderValuePostView, costOfSale, impressionWin, costPerOrder
#' @param start Start Date, format: "YYYY-mm-dd"
#' @param end End Date, format: "YYYY-mm-dd"
#' 
#' @export
#' @return Report job ID
scedCriteoReport <- function(authToken, appToken, campaigns, metrics, start, end){
  camp = paste('<int>',campaigns,'</int>\n',collapse="",sep="")
  metr = paste('<ReportColumn>',metrics,'</ReportColumn>\n',collapse = "",sep="")
  body = paste('<?xml version="1.0" encoding="utf-8"?>
               <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
               <soap:Header>
               <apiHeader xmlns="https://advertising.criteo.com/API/v201010">
               <authToken>', authToken ,'</authToken>
               <appToken>', appToken ,'</appToken>
               <clientVersion>3.6</clientVersion>
               </apiHeader>
               </soap:Header>
               <soap:Body>
               <scheduleReportJob xmlns="https://advertising.criteo.com/API/v201010">
               <reportJob>
               <selectedColumns>',
               metr,
               '</selectedColumns>
               <reportSelector>
               <CampaignIDs>',
               camp,
               '</CampaignIDs>
               </reportSelector>
               <reportType>Campaign</reportType>
               <aggregationType>Daily</aggregationType>
               <startDate>',start,'</startDate>
               <endDate>',end,'</endDate>
               <isResultGzipped>false</isResultGzipped>
               </reportJob>
               </scheduleReportJob>
               </soap:Body>
               </soap:Envelope>', sep='')
        
          headerFields = c(Accept = "text/xml",
                           Accept = "multipart/*",
                           'Content-Type' = "text/xml; charset=utf-8",
                           SOAPAction = "https://advertising.criteo.com/API/v201010/scheduleReportJob")
        
          h = RCurl::basicTextGatherer()
          
          RCurl::curlPerform(url = "https://advertising.criteo.com/API/v201010/AdvertiserService.asmx",
                      httpheader = headerFields,
                      postfields = body,
                      writefunction = h$update
          )
          
          data <- XML::xmlParse(h$value())
          data <- XML::xmlToList(data)
          data <- data$Body$scheduleReportJobResponse$jobResponse$jobID
          attr(data, "metrics") <- metrics
          data
}