#' @title Get Campaign Report Data
#' 
#' @description This function returns the requested data as a data frame.
#' 
#' @param URL Report download URL created by \code{\link{getCriteoDownloadURL}}
#' @param jobID jobID generated by \code{\link{scedCriteoReport}}
#' 
#' @return Data
#' 
#' @export
getCriteoData <- function(URL, jobID){
  #get http content from download url
  data <- httr::content(httr::GET(URL))
  #parse xml
  xmlTop <- XML::xmlRoot(data)
  xmlData <- xmlTop[["table"]][["rows"]]
  #convert xml to list and dataframe
  myList <- XML::xmlToList(xmlData)
  df <- data.frame(matrix(unlist(myList), nrow=length(myList), byrow=T))
  #eliminate timestamp
  df[,2] <- NULL
  #rename columns
  CampaignID <- NULL
  Date <- NULL
  names(df)[1:2] <- c("CampaignID", "Date")
  names(df)[3:ncol(df)] <- attributes(jobID)$metrics
  df$Date <- as.Date(df$Date)
  #convert factor into numeric
  df[,3:ncol(df)] = sapply(df[,3:ncol(df)], as.character)
  df[,3:ncol(df)] = sapply(df[,3:ncol(df)], as.numeric)
  #rearrange dataframe
  df <- plyr::arrange(df, CampaignID, Date)
  df
}