#' Catalogue of East Caucasian languages
#'
#' A dataset containes metadata on East Caucasian languages that helps
#' RCaucTile to function.
#'
#' @format
#' A data frame with 56 rows and 11 variables:
#' \describe{
#'   \item{language}{- language name}
#'   \item{x}{- suggested x coordinate for the tile map}
#'   \item{y}{- suggested y coordinate for the tile map}
#'   \item{branch}{- language branch}
#'   \item{family}{- language family}
#'   \item{glottocode}{- language glottocode}
#'   \item{language_color}{- suggested language color}
#'   \item{branch_color}{- suggested branch color}
#'   \item{abbreviation}{- suggested abbreviation}
#'   \item{morning_greetings}{This variable contains values from the \href{https://lingconlab.ru/tald/005_morning_greetings.html}{"Morning Greetings" chapter} (Naccarato, Verhees 2021) from the Typological Atlas of the Languages of Daghestan. The languages of Daghestan can be classified into three groups according to whether they feature morning greetings including questions about the night’s rest (value `Did you wake up?`), based on the combination of concepts like “morning” and “good” (value `Good morning`), and both stratagies (value `Both`).}
#'   \item{consonant_inventory_size}{This variable contains consonant inventory sizes based on \href{https://lingconlab.ru/tald/phonology.html}{"Phonology" chapter} (Moroz 2021) from the Typological Atlas of the Languages of Daghestan.}
#' }
#'
#' @references Moroz, George (2021). “On phonology of East Caucasian languages”. In: Typological Atlas of the Languages of Daghestan (TALD), v 2.0.0. Ed. by Michael Daniel, Konstantin Filatov, Timur Maisak, George Moroz, Timofey Mukhin, Chiara Naccarato and Samira Verhees. Moscow: Linguistic Convergence Laboratory, NRU HSE. DOI: 10.5281/zenodo.6807070. https://lingconlab.ru/tald.
#' @references Naccarato, Chiara and Samira Verhees (2021). “Morning greetings”. In: Typological Atlas of the Languages of Daghestan (TALD), v 2.0.0. Ed. by Michael Daniel, Konstantin Filatov, Timur Maisak, George Moroz, Timofey Mukhin, Chiara Naccarato and Samira Verhees. Moscow: Linguistic Convergence Laboratory, NRU HSE. DOI: 10.5281/zenodo.6807070. https://lingconlab.ru/tald.

"ec_languages"
