% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{define_object_for_initial_clustering_macropca}
\alias{define_object_for_initial_clustering_macropca}
\title{Defines the object that will be used to define a initial clustering.}
\usage{
define_object_for_initial_clustering_macropca(
  robust,
  Y,
  k,
  kg,
  comfactor,
  method_estimate_beta = "individual",
  method_estimate_factors = "macro",
  verbose = FALSE
)
}
\arguments{
\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{Y}{Y: NxT dataframe with the panel data of interest}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{comfactor}{estimated common factors}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{method_estimate_factors}{specifies the robust algorithm to estimate factors: default is "macro". The value is not used when robust is set to FALSE.}

\item{verbose}{when TRUE, it prints messages}
}
\value{
matrix with N rows and 10 columns
}
\description{
This is a short version of define_object_for_initial_clustering() which only contains implementations for robust macropca case and classical case.
}
