% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_PIC}
\alias{calculate_PIC}
\title{Function to determine PIC (panel information criterium)}
\usage{
calculate_PIC(
  C,
  robust,
  S,
  k,
  kg,
  e2,
  sigma2,
  NN,
  TT,
  method_estimate_beta,
  beta_est,
  g,
  vars_est,
  choice_pic = "pic2022"
)
}
\arguments{
\item{C}{determines relative contribution of the penalty terms compared to the estimation error term}

\item{robust}{TRUE or FALSE: defines using the classical or robust algorithm to estimate beta}

\item{S}{number of estimated groups}

\item{k}{number of common factors to be estimated}

\item{kg}{number of group specific factors to be estimated}

\item{e2}{NxT matrix with error terms}

\item{sigma2}{scalar: sum of squared error terms, scaled by NT}

\item{NN}{number of time series}

\item{TT}{length of time series}

\item{method_estimate_beta}{defines how beta is estimated. Default case is an estimated beta for each individual. Default value is "individual." Possible values are "homogeneous", "group" or "individual".}

\item{beta_est}{estimated values of beta}

\item{g}{Vector with estimated group membership for all individuals}

\item{vars_est}{number of variables that will be included in the algorithm and have their coefficient estimated. This is usually equal to the number of observable variables.}

\item{choice_pic}{indicates which PIC to use to estimate the number of groups and factors:
options are "pic2017" (uses the PIC of \insertCite{Ando2017;textual}{RCTS}; works better for large N),
"pic2016" (\insertCite{Ando2016;textual}{RCTS}; works better for large T) weighs the fourth term with an extra factor relative to the size of the groups,
and "pic2022" which shrinks the NT-space where the number of groups and factors would be over- or underestimated compared to pic2016 and pic2017.}
}
\value{
numeric
}
\description{
This depends on kappa1 -> kappaN, through p (=number of nonzero elements of beta_est).
The parameter 'sigma2' is the non-robust sigma2. As it is only used in term 2 to 4, it does not actually matter what its value is (needs to be > 0).
It could be set to 1 as well.
}
\examples{
set.seed(1)
NN <- 30
TT <- 10
e <- matrix(rnorm(NN * TT), nrow = NN)
beta_est <- matrix(rnorm(NN * 4), ncol = NN) #random values for beta
g <- round(runif(NN, 1, 3))
calculate_PIC(0.51, TRUE, 3, 0, c(3, 3, 3), e, e^2/(NN*TT), NN, TT, "individual", beta_est, g, 3)
}
