% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pathway-bar-chart.R
\name{plotBarChart}
\alias{plotBarChart}
\title{Plot a bar chart of the pathway analysis results}
\usage{
plotBarChart(
  results,
  limit = Inf,
  label = "name",
  by = c("normalizedScore", "score", "pFDR", "p.value"),
  maxNegLog10PValue = 5,
  pThreshold = 0.05,
  useFDR = TRUE,
  selectedPathways = NULL
)
}
\arguments{
\item{results}{A named list of data frame with pathway analysis results.
The columns are ID, name, p.value, pFDR, size, nDE, score and normalizedScore.}

\item{limit}{The maximum number of pathways to plot.
The pathway will be sorted by the average absolute value of the -log10(p-value) or -log10(pFDR) if the 'by' parameter is 'p.value' or 'pFDR'.
Otherwise, the pathway will be sorted by the average value of the 'by' parameter.}

\item{label}{The column to use for the labels.}

\item{by}{The column to use for the bar heights.}

\item{maxNegLog10PValue}{The maximum -log10(p-value) to plot.}

\item{pThreshold}{The p-value threshold to use for significance.}

\item{useFDR}{If TRUE, use FDR adjusted p-values for the significance threshold. Otherwise, use raw p-values.
This parameter is used to mark the color of the bars and is independent of the 'by' parameter.}

\item{selectedPathways}{A vector of pathways ID, which is in the same format as ID column in the pathway analysis result, to be included in the plot.
If it is NULL, all pathways will be included.}
}
\value{
A ggplot2 object.
}
\description{
This function plots a bar chart of the pathway analysis results.
}
\examples{
\donttest{
library(RCPA)

affyFgseaResult <- loadData("affyFgseaResult")
agilFgseaResult <- loadData("agilFgseaResult")
RNASeqFgseaResult <- loadData("RNASeqFgseaResult")
metaPAResult <- loadData("metaPAResult")

PAResults <- list(
    "Affymetrix - GSE5281" = affyFgseaResult,
    "Agilent - GSE61196" = agilFgseaResult,
    "RNASeq - GSE153873" = RNASeqFgseaResult,
    "Meta-analysis" = metaPAResult
)

selectedPathways <- c("path:hsa05010", "path:hsa05012", "path:hsa05014", 
                       "path:hsa05016", "path:hsa05017", "path:hsa05020", 
                       "path:hsa05022", "path:hsa04724", "path:hsa04727", 
                       "path:hsa04725", "path:hsa04728", "path:hsa04726",
                      "path:hsa04720", "path:hsa04730", "path:hsa04723", 
                      "path:hsa04721", "path:hsa04722")
resultsToPlot <- lapply(PAResults, 
                    function(df) df[df$ID \%in\% selectedPathways,])

plotObj <- RCPA::plotBarChart(resultsToPlot) + 
            ggplot2::ggtitle("FGSEA Analysis Results")

}
}
