% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta-analysis.R
\name{runDEMetaAnalysis}
\alias{runDEMetaAnalysis}
\title{Combine DE analysis results}
\usage{
runDEMetaAnalysis(
  DEResults,
  method = c("stouffer", "fisher", "addCLT", "geoMean", "minP", "REML")
)
}
\arguments{
\item{DEResults}{A list of dataframes containing DE analysis results.
Each dataframe must have ID, p.value, logFC and logFCSE columns.}

\item{method}{The method to combine p-values. It can be one of "fisher", "stouffer", "geoMean", "addCLT", "minP".}
}
\value{
A dataframe containing combined DE analysis results.
The dataframe has ID, p.value, pDFR, logFC, and logFCSE columns.
}
\description{
This function performs mata analysis on multiple DE analysis results.
}
\examples{
\donttest{
library(RCPA)
library(SummarizedExperiment)
affyDEExperiment <- loadData("affyDEExperiment")
agilDEExperiment <- loadData("agilDEExperiment")
RNASeqDEExperiment <- loadData("RNASeqDEExperiment")

metaDEResult <- RCPA::runDEMetaAnalysis(list(
    rowData(affyDEExperiment),
    rowData(agilDEExperiment),
    rowData(RNASeqDEExperiment)
), method = "stouffer")
}
}
