% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_objects}
\alias{get_objects}
\title{Extract objects of prepositional phrases in row and column labels}
\usage{
get_objects(
  labels,
  inf_notation = TRUE,
  notation = RCLabels::notations_list,
  choose_most_specific = FALSE,
  prepositions = RCLabels::prepositions_list
)
}
\arguments{
\item{labels}{The row and column labels from which prepositional phrases are to be extracted.}

\item{inf_notation}{A boolean that tells whether to infer notation for \code{x}.
Default is \code{TRUE}.
See \code{infer_notation()} for details.}

\item{notation}{The notation type to be used when extracting prepositions.
Default is \code{RCLabels::notations_list}, meaning that
the notation is inferred using \code{infer_notation()}.}

\item{choose_most_specific}{A boolean that tells whether to choose the most specific
notation from \code{notation} when inferring notation.
Default is \code{FALSE} so that a less specific notation can be
inferred.
In combination with \code{RCLabels::notations_list},
the default value of \code{FALSE} means that
\code{RCLabels::bracket_notation} will be selected instead of
anything more specific, such as
\code{RCLabels::from_notation}.}

\item{prepositions}{A vector of strings to be treated as prepositions.
Note that a space is appended to each word internally,
so, e.g., "to" becomes "to ".
Default is \code{RCLabels::prepositions_list}.}
}
\value{
A list of objects of prepositional phrases,
with names being prepositions, and values being objects.
}
\description{
This function extracts the objects of prepositional phrases
from row and column labels.
The format of the output is a list of
named items, one name for each preposition encountered in labels.
Objects are \code{NA} if there is no prepositional phrase starting
with that preposition.
}
\examples{
get_objects(c("a [of b into c]", "d [of Coal from e -> f]"))
}
