% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setters.R
\name{modify_nouns}
\alias{modify_nouns}
\title{Modify nouns in labels}
\usage{
modify_nouns(labels, new_nouns, notation = RCLabels::bracket_notation)
}
\arguments{
\item{labels}{The row and column labels in which the nouns will be modified.}

\item{new_nouns}{The new nouns to be set in \code{labels}.
Must be same length as \code{labels}.}

\item{notation}{The notation used in \code{labels}.
Default is \code{RCLabels::bracket_notation}.}
}
\value{
A character vector of same length as labels
with nouns modified to be \code{new_nouns}.
}
\description{
This function modifies the nouns of row and column labels.
The length of \code{new_nouns} must be the same as the length of \code{labels}.
}
\examples{
labels <- c("a [of b in c]", "d [of e in USA]")
modify_nouns(labels, c("a_plus", "g"))
}
