% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustify.R
\name{robustify}
\alias{robustify}
\alias{robustify.betaMix}
\alias{robustify.gammaMix}
\alias{robustify.normMix}
\title{Robustify Mixture Priors}
\usage{
robustify(priormix, weight, mean, n = 1, ...)

\method{robustify}{betaMix}(priormix, weight, mean, n = 1, ...)

\method{robustify}{gammaMix}(priormix, weight, mean, n = 1, ...)

\method{robustify}{normMix}(priormix, weight, mean, n = 1, ..., sigma)
}
\arguments{
\item{priormix}{orior (mixture of conjugate distributions).}

\item{weight}{weight given to the non-informative component (0 < \code{weight} < 1).}

\item{mean}{mean of the non-informative component. It is recommended to set this parameter explicitly.}

\item{n}{number of observations the non-informative prior
corresponds to, defaults to 1.}

\item{...}{optional arguments are ignored.}

\item{sigma}{Sampling standard deviation for the case of Normal
mixtures.}
}
\value{
New mixture with an extra non-informative component named
\code{robust}.
}
\description{
Add a non-informative component to a mixture prior.
}
\details{
It is recommended to robustify informative priors derived
with \code{\link{gMAP}} using unit-information priors . This
protects against prior-data conflict, see for example
\emph{Schmidli et al., 2015}.

The procedure can be used with beta, gamma and normal mixture
priors. A unit-information prior (see \emph{Kass and Wasserman,
1995}) corresponds to a prior which represents the observation of
n=1 at the null hypothesis. As the null is problem dependent we
\emph{strongly recommend} to make use of the \code{mean} argument
accordingly. See below for the definition of the default mean.

The weights of the mixture priors are rescaled to \code{(1-weight)}
while the non-informative prior is assigned the \code{weight}
given.
}
\section{Methods (by class)}{
\itemize{
\item \code{robustify(betaMix)}: The default \code{mean} is set to 1/2 which
represents no difference between the occurrence rates for one of the
two outcomes. As the uniform \code{Beta(1,1)} is more appropriate in
practical applications, \code{RBesT} uses \code{n+1} as the sample
size such that the default robust prior is the uniform instead of
the \code{Beta(1/2,1/2)} which strictly defined would be the unit
information prior in this case.

\item \code{robustify(gammaMix)}: The default \code{mean} is set to the mean of the
prior mixture. It is strongly recommended to explicitly set the
mean to the location of the null hypothesis.

\item \code{robustify(normMix)}: The default \code{mean} is set to the mean
of the prior mixture. It is strongly recommended to explicitly set
the mean to the location of the null hypothesis, which is very
often equal to 0. It is also recommended to explicitly set the
sampling standard deviation using the \code{sigma} argument.

}}
\examples{
bmix <- mixbeta(inf1 = c(0.2, 8, 3), inf2 = c(0.8, 10, 2))
plot(bmix)
rbmix <- robustify(bmix, weight = 0.1, mean = 0.5)
rbmix
plot(rbmix)

gmnMix <- mixgamma(inf1 = c(0.2, 2, 3), inf2 = c(0.8, 2, 5), param = "mn")
plot(gmnMix)
rgmnMix <- robustify(gmnMix, weight = 0.1, mean = 2)
rgmnMix
plot(rgmnMix)

nm <- mixnorm(inf1 = c(0.2, 0.5, 0.7), inf2 = c(0.8, 2, 1), sigma = 2)
plot(nm)
rnMix <- robustify(nm, weight = 0.1, mean = 0, sigma = 2)
rnMix
plot(rnMix)

}
\references{
Schmidli H, Gsteiger S, Roychoudhury S, O'Hagan A,
Spiegelhalter D, Neuenschwander B.  Robust meta-analytic-predictive
priors in clinical trials with historical control information.
\emph{Biometrics} 2014;70(4):1023-1032.

Kass RE, Wasserman L A Reference Bayesian Test for Nested
Hypotheses and its Relationship to the Schwarz Criterion \emph{J
Amer Statist Assoc} 1995; 90(431):928-934.
}
\seealso{
\code{\link{mixcombine}}
}
